/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.db;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import tigase.archive.db.AbstractMessageArchiveRepository;
import tigase.archive.db.MessageArchiveRepository;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataSource;
import tigase.db.TigaseDBException;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.Query;
import tigase.xmpp.mam.util.MAMUtil;
import tigase.xmpp.mam.util.Range;
import tigase.xmpp.rsm.RSM;

public class AbstractMessageArchiveRepositoru_calculateRsmTest {
    private DummyMessageArchiveRepository repo = new DummyMessageArchiveRepository();

    @Test
    public void testRangeSize1() {
        Range range = new Range(5, 10);
        Assert.assertEquals((long)5L, (long)range.size());
    }

    @Test
    public void testRangeSize2() {
        Range range = MAMUtil.rangeFromPositions((Integer)5, (Integer)10);
        Assert.assertEquals((long)4L, (long)range.size());
    }

    @Test
    public void testRsmCalculcationPlainRSM() {
        int count = 50;
        RSM rsm = new RSM(100);
        this.repo.calculateOffsetAndPosition(rsm, count, null, null);
        Assert.assertEquals((long)50L, (long)rsm.getCount().intValue());
        Assert.assertEquals((long)100L, (long)rsm.getMax());
    }

    @Test
    public void testRsmCalculcationPlain_RSMAfterId() {
        int count = 50;
        RSM rsm = new RSM(100);
        this.repo.calculateOffsetAndPosition(rsm, count, null, 10);
        Assert.assertEquals((long)50L, (long)rsm.getCount().intValue());
        Assert.assertEquals((long)11L, (long)rsm.getIndex().intValue());
        Assert.assertEquals((long)100L, (long)rsm.getMax());
    }

    @Test
    public void testRsmCalculcationPlain_RSMBeforeId() {
        int count = 50;
        RSM rsm = new RSM(20);
        this.repo.calculateOffsetAndPosition(rsm, count, 30, null);
        Assert.assertEquals((long)50L, (long)rsm.getCount().intValue());
        Assert.assertEquals((long)10L, (long)rsm.getIndex().intValue());
        Assert.assertEquals((long)20L, (long)rsm.getMax());
    }

    @Test
    public void testRsmCalculcationPlain_RSMHasBefore() {
        int count = 50;
        RSM rsm = new RSM(15);
        this.repo.calculateOffsetAndPosition(rsm, count, 30, null);
        Assert.assertEquals((long)50L, (long)rsm.getCount().intValue());
        Assert.assertEquals((long)15L, (long)rsm.getIndex().intValue());
        Assert.assertEquals((long)15L, (long)rsm.getMax());
    }

    @Test
    public void testRsmCalculationExtended_AfterId() {
        int count = 50;
        RSM rsm = new RSM(100);
        Range range = MAMUtil.rangeFromPositions((Integer)9, null);
        MAMUtil.calculateOffsetAndPosition((RSM)rsm, (int)count, null, null, (Range)range);
        Assert.assertEquals((long)40L, (long)rsm.getCount().intValue());
        Assert.assertEquals((long)0L, (long)rsm.getIndex().intValue());
        Assert.assertEquals((long)40L, (long)rsm.getMax());
    }

    @Test
    public void testRsmCalculationExtended_BeforeId() {
        int count = 50;
        RSM rsm = new RSM(100);
        Range range = MAMUtil.rangeFromPositions(null, (Integer)40);
        MAMUtil.calculateOffsetAndPosition((RSM)rsm, (int)count, null, null, (Range)range);
        Assert.assertEquals((long)40L, (long)rsm.getCount().intValue());
        Assert.assertEquals((long)0L, (long)rsm.getIndex().intValue());
        Assert.assertEquals((long)40L, (long)rsm.getMax());
    }

    @Test
    public void testRsmCalculationExtended_AfterIdAndBeforeId() {
        int count = 50;
        RSM rsm = new RSM(100);
        Range range = MAMUtil.rangeFromPositions((Integer)9, (Integer)40);
        MAMUtil.calculateOffsetAndPosition((RSM)rsm, (int)count, null, null, (Range)range);
        Assert.assertEquals((long)30L, (long)rsm.getCount().intValue());
        Assert.assertEquals((long)0L, (long)rsm.getIndex().intValue());
        Assert.assertEquals((long)30L, (long)rsm.getMax());
    }

    @Test
    public void testRsmCalculationExtended_AfterIdAndBeforeIdAndRSMAfterId() {
        int count = 50;
        RSM rsm = new RSM(100);
        Range range = MAMUtil.rangeFromPositions((Integer)9, (Integer)40);
        MAMUtil.calculateOffsetAndPosition((RSM)rsm, (int)count, null, (Integer)14, (Range)range);
        Assert.assertEquals((long)30L, (long)rsm.getCount().intValue());
        Assert.assertEquals((long)5L, (long)rsm.getIndex().intValue());
        Assert.assertEquals((long)25L, (long)rsm.getMax());
    }

    @Test
    public void testRsmCalculationExtended_AfterIdAndBeforeIdAndRSMBeforeId() {
        int count = 50;
        RSM rsm = new RSM(20);
        Range range = MAMUtil.rangeFromPositions((Integer)9, (Integer)40);
        MAMUtil.calculateOffsetAndPosition((RSM)rsm, (int)count, (Integer)36, null, (Range)range);
        Assert.assertEquals((long)30L, (long)rsm.getCount().intValue());
        Assert.assertEquals((long)6L, (long)rsm.getIndex().intValue());
        Assert.assertEquals((long)20L, (long)rsm.getMax());
    }

    @Test
    public void testRsmCalculationExtended_AfterIdAndBeforeIdAndRSMHasBefore() {
        int count = 50;
        RSM rsm = new RSM(20);
        rsm.setHasBefore(true);
        Range range = MAMUtil.rangeFromPositions((Integer)9, (Integer)40);
        MAMUtil.calculateOffsetAndPosition((RSM)rsm, (int)count, null, null, (Range)range);
        Assert.assertEquals((long)30L, (long)rsm.getCount().intValue());
        Assert.assertEquals((long)10L, (long)rsm.getIndex().intValue());
        Assert.assertEquals((long)20L, (long)rsm.getMax());
    }

    @Test
    public void testRsmCalculationExtended_RSMAfterId() {
        int count = 50;
        RSM rsm = new RSM(100);
        Range range = Range.FULL;
        MAMUtil.calculateOffsetAndPosition((RSM)rsm, (int)count, null, (Integer)14, (Range)range);
        Assert.assertEquals((long)50L, (long)rsm.getCount().intValue());
        Assert.assertEquals((long)15L, (long)rsm.getIndex().intValue());
        Assert.assertEquals((long)35L, (long)rsm.getMax());
    }

    @Test
    public void testRsmCalculationExtended_RSMBeforeId() {
        int count = 50;
        RSM rsm = new RSM(20);
        Range range = Range.FULL;
        MAMUtil.calculateOffsetAndPosition((RSM)rsm, (int)count, (Integer)35, null, (Range)range);
        Assert.assertEquals((long)50L, (long)rsm.getCount().intValue());
        Assert.assertEquals((long)15L, (long)rsm.getIndex().intValue());
        Assert.assertEquals((long)20L, (long)rsm.getMax());
    }

    @Test
    public void testRsmCalculationExtended_RSMHasBefore() {
        int count = 50;
        RSM rsm = new RSM(20);
        rsm.setHasBefore(true);
        Range range = Range.FULL;
        MAMUtil.calculateOffsetAndPosition((RSM)rsm, (int)count, null, null, (Range)range);
        Assert.assertEquals((long)50L, (long)rsm.getCount().intValue());
        Assert.assertEquals((long)30L, (long)rsm.getIndex().intValue());
        Assert.assertEquals((long)20L, (long)rsm.getMax());
    }

    private class DummyMessageArchiveRepository
    extends AbstractMessageArchiveRepository {
        private DummyMessageArchiveRepository() {
        }

        public void archiveMessage(BareJID owner, JID buddy, Date timestamp, Element msg, String stableId, Set tags) {
            throw new RuntimeException("Feature not implemented");
        }

        public void deleteExpiredMessages(BareJID owner, LocalDateTime before) throws TigaseDBException {
            throw new RuntimeException("Feature not implemented");
        }

        public String getStableId(BareJID owner, BareJID buddy, String stanzaId) throws TigaseDBException {
            throw new RuntimeException("Feature not implemented");
        }

        public void queryItems(Query query, MAMRepository.ItemHandler itemHandler) throws RepositoryException, ComponentException {
            throw new RuntimeException("Feature not implemented");
        }

        public Query newQuery() {
            throw new RuntimeException("Feature not implemented");
        }

        public void removeItems(BareJID owner, String withJid, Date start, Date end) throws TigaseDBException {
            throw new RuntimeException("Feature not implemented");
        }

        public List<String> getTags(BareJID owner, String startsWith, tigase.archive.xep0136.Query criteria) throws TigaseDBException {
            throw new RuntimeException("Feature not implemented");
        }

        public void queryCollections(tigase.archive.xep0136.Query query, MessageArchiveRepository.CollectionHandler collectionHandler) throws TigaseDBException {
            throw new RuntimeException("Feature not implemented");
        }

        public void setDataSource(DataSource dataSource) throws RepositoryException {
            throw new RuntimeException("Feature not implemented");
        }

        protected void archiveMessage(BareJID owner, BareJID buddy, Date timestamp, Element msg, String stableId, String stanzaId, String refStableId, Set tags, AbstractMessageArchiveRepository.AddMessageAdditionalDataProvider additionParametersProvider) {
            throw new RuntimeException("Feature not implemented");
        }
    }
}

