/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import tigase.archive.TagsHelper;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class TagsHelperTest {
    @Test
    public void testExtractTags_Element() {
        Set result = TagsHelper.extractTags(null);
        Assert.assertTrue((String)"Found tags in empty message 1", (boolean)result.isEmpty());
        Element msg = new Element("message");
        result = TagsHelper.extractTags(null);
        Assert.assertTrue((String)"Found tags in empty message 2", (boolean)result.isEmpty());
        msg.addChild((XMLNodeIfc)new Element("body", "some data here"));
        Assert.assertTrue((String)"Found tags in empty message 3", (boolean)result.isEmpty());
        msg = new Element("message");
        String body = "Example message about #Tigase with @User1";
        HashSet<String> expResult = new HashSet<String>();
        expResult.add("#Tigase");
        expResult.add("@User1");
        msg.addChild((XMLNodeIfc)new Element("body", body));
        result = TagsHelper.extractTags((Element)msg);
        Assert.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testExtractTags_Set_String() {
        HashSet tags = new HashSet();
        Set result = TagsHelper.extractTags(tags, (String)"no tags in string");
        Assert.assertTrue((String)"Found tags in body with no tags", (boolean)result.isEmpty());
        String body = "Example message about #Tigase with @User1";
        HashSet<String> expResult = new HashSet<String>();
        expResult.add("#Tigase");
        expResult.add("@User1");
        result = TagsHelper.extractTags(tags, (String)body);
        Assert.assertEquals((String)"found other tags than expected", expResult, (Object)result);
    }

    @Test
    public void testMatches() {
        String part = "";
        boolean expResult = false;
        boolean result = TagsHelper.matches((String)part);
        Assert.assertEquals((Object)expResult, (Object)result);
        part = "test";
        expResult = false;
        result = TagsHelper.matches((String)part);
        Assert.assertEquals((Object)expResult, (Object)result);
        part = "@test";
        expResult = true;
        result = TagsHelper.matches((String)part);
        Assert.assertEquals((Object)expResult, (Object)result);
        part = "#test";
        expResult = true;
        result = TagsHelper.matches((String)part);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testProcess() {
        String tag = "@test";
        String expResult = "@test";
        String result = TagsHelper.process((String)tag);
        Assert.assertEquals((Object)expResult, (Object)result);
        tag = "@test..";
        expResult = "@test";
        result = TagsHelper.process((String)tag);
        Assert.assertEquals((Object)expResult, (Object)result);
    }
}

