/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.MessageArchiveConfig;
import tigase.archive.MessageArchiveVHostItemExtension;
import tigase.archive.RetentionType;
import tigase.archive.db.MessageArchiveRepository;
import tigase.component.AbstractKernelBasedComponent;
import tigase.component.modules.impl.DiscoveryModule;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.util.common.TimerTask;
import tigase.vhosts.VHostItem;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.modules.GetFormModule;

@Bean(name="message-archive", parent=Kernel.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode})
public class MessageArchiveComponent
extends AbstractKernelBasedComponent
implements MessageArchiveConfig,
UnregisterAware {
    private static final Logger log = Logger.getLogger(MessageArchiveComponent.class.getCanonicalName());
    private static final String TAGS_SUPPORT_PROP_KEY = "tags-support";
    private static final String REMOVE_EXPIRED_MESSAGES_KEY = "remove-expired-messages";
    private static final String REMOVE_EXPIRED_MESSAGES_DELAY_KEY = "remove-expired-messages-delay";
    private static final String REMOVE_EXPIRED_MESSAGES_PERIOD_KEY = "remove-expired-messages-period";
    @Inject
    protected MessageArchiveRepository msg_repo = null;
    private RemoveExpiredTask expiredMessagesRemovalTask = null;
    private float expiredMessagesRemovalTimeAvg = -1.0f;
    @ConfigField(desc="Remove expired messages from repository", alias="remove-expired-messages")
    private boolean removeExpiredMessages = false;
    @ConfigField(desc="Initial delay since server statup until removal of expired messages", alias="remove-expired-messages-delay")
    private Duration removeExpiredMessagesDelay = Duration.ofHours(1L);
    @ConfigField(desc="Period between expired message removals", alias="remove-expired-messages-period")
    private Duration removeExpiredMessagesPeriod = Duration.ofDays(1L);
    @ConfigField(desc="Tag support enabled", alias="tags-support")
    private boolean tagsSupport = false;

    public MessageArchiveComponent() {
        this.setName("message-archive");
    }

    public int hashCodeForPacket(Packet packet) {
        if (packet.getElemName() == "message" && packet.getPacketFrom() != null && !this.getComponentId().equals((Object)packet.getPacketFrom())) {
            return packet.getPacketFrom().hashCode();
        }
        if (packet.getStanzaFrom() != null && !this.getComponentId().equals((Object)packet.getStanzaFrom())) {
            return packet.getStanzaFrom().getBareJID().hashCode();
        }
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().hashCode();
        }
        return 1;
    }

    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    public int processingOutThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    public String getComponentVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        return version == null ? "0.0.0" : version;
    }

    public boolean isDiscoNonAdmin() {
        return false;
    }

    public String getDiscoDescription() {
        return "Message Archiving Component";
    }

    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Removal time of expired messages (avg)", this.expiredMessagesRemovalTimeAvg, Level.FINE);
    }

    public void initialize() {
        super.initialize();
        this.eventBus.registerAll((Object)this);
    }

    public void beforeUnregister() {
        this.eventBus.unregisterAll((Object)this);
    }

    @HandleEvent
    public void onUserRemoved(UserRepository.UserRemovedEvent event) {
        try {
            this.msg_repo.removeItems(event.jid, null, null, null);
        }
        catch (TigaseDBException ex) {
            log.log(Level.FINE, "Could not remove entries for removed user " + event.jid, ex);
        }
    }

    public void beanConfigurationChanged(Collection<String> changedFields) {
        super.beanConfigurationChanged(changedFields);
        if (changedFields.contains(REMOVE_EXPIRED_MESSAGES_KEY) || changedFields.contains(REMOVE_EXPIRED_MESSAGES_PERIOD_KEY) || changedFields.contains(REMOVE_EXPIRED_MESSAGES_DELAY_KEY)) {
            if (this.expiredMessagesRemovalTask != null) {
                this.expiredMessagesRemovalTask.cancel();
                this.expiredMessagesRemovalTask = null;
            }
            if (this.removeExpiredMessages) {
                long initialDelay = this.removeExpiredMessagesDelay.toMillis();
                long period = this.removeExpiredMessagesPeriod.toMillis();
                log.log(Level.FINE, "scheduling removal of expired messages to once every {0}ms after initial delay of {1}ms", new Object[]{period, initialDelay});
                this.expiredMessagesRemovalTask = new RemoveExpiredTask();
                this.addTimerTask(this.expiredMessagesRemovalTask, initialDelay, period);
            }
        }
    }

    @Override
    public boolean isTagSupportEnabled() {
        return this.tagsSupport;
    }

    protected void registerModules(Kernel kernel) {
        kernel.registerBean(DiscoveryModule.class).exec();
        kernel.registerBean(GetFormModule.class).exec();
    }

    private class RemoveExpiredTask
    extends TimerTask {
        private RemoveExpiredTask() {
        }

        public void run() {
            float time = 0.0f;
            float count = 0.0f;
            for (JID vhost : MessageArchiveComponent.this.vHostManager.getAllVHosts()) {
                try {
                    VHostItem item = MessageArchiveComponent.this.vHostManager.getVHostItem(vhost.getDomain());
                    MessageArchiveVHostItemExtension extension = (MessageArchiveVHostItemExtension)item.getExtension(MessageArchiveVHostItemExtension.class);
                    if (extension != null) {
                        RetentionType retentionType = extension.getRetentionType();
                        switch (retentionType) {
                            case numberOfDays: {
                                Integer days = extension.getRetentionDays();
                                if (days == null) break;
                                long start = System.currentTimeMillis();
                                LocalDateTime timestamp = LocalDateTime.now(ZoneId.of("Z")).minusDays(days.intValue());
                                MessageArchiveComponent.this.msg_repo.deleteExpiredMessages(vhost.getBareJID(), timestamp);
                                long stop = System.currentTimeMillis();
                                long executedIn = stop - start;
                                time += (float)executedIn;
                                log.log(Level.FINEST, "removed messsages older than {0} for domain {1} in {2}ms", new Object[]{timestamp.toString(), vhost.getDomain(), executedIn});
                                count += 1.0f;
                                break;
                            }
                            case userDefined: 
                            case unlimited: {
                                log.log(Level.FINEST, "skipping removal of expired messages for domain {0} as removal for retention type {1} is not supported", new Object[]{vhost.getDomain(), retentionType});
                            }
                        }
                        continue;
                    }
                    log.log(Level.FINEST, "skipping removal of expired messages for domain {0} as retention type is not defined", new Object[]{vhost.getDomain()});
                }
                catch (Exception ex) {
                    log.log(Level.FINE, "exception removing expired messages", ex);
                }
            }
            MessageArchiveComponent.this.expiredMessagesRemovalTimeAvg = count > 0.0f ? time / count : -1.0f;
        }
    }
}

