/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.xep0313;

import tigase.archive.MessageArchiveComponent;
import tigase.archive.MessageArchiveConfig;
import tigase.component.exceptions.ComponentException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.mam.Query;

@Bean(name="mamQueryParser", parent=MessageArchiveComponent.class, active=true)
public class MAMQueryParser
extends tigase.xmpp.mam.MAMQueryParser {
    private static final String CONTAINS_FIELD_NAME = "tigase:body:contains";
    private static final String TAGS_FIELD_NAME = "tigase:tags";
    @Inject(bean="service")
    private MessageArchiveConfig config;

    public Query parseQuery(Query query, Packet packet) throws ComponentException {
        String[] tags;
        Query result = super.parseQuery(query, packet);
        Element queryEl = packet.getElement().getChildStaticStr("query", "urn:xmpp:mam:1");
        String[] contains = DataForm.getFieldValues((Element)queryEl, (String)CONTAINS_FIELD_NAME);
        if (contains != null && contains.length > 0) {
            if (!(query instanceof tigase.archive.xep0136.Query)) {
                throw new ComponentException(Authorization.BAD_REQUEST, "Unsupported feature tigase:body:contains");
            }
            for (String it : contains) {
                ((tigase.archive.xep0136.Query)query).addContains(it);
            }
        }
        if ((tags = DataForm.getFieldValues((Element)queryEl, (String)TAGS_FIELD_NAME)) != null && tags.length > 0) {
            if (!(query instanceof tigase.archive.xep0136.Query) || !this.config.isTagSupportEnabled()) {
                throw new ComponentException(Authorization.BAD_REQUEST, "Unsupported feature tigase:tags");
            }
            for (String it : tags) {
                ((tigase.archive.xep0136.Query)query).addTag(it);
            }
        }
        return result;
    }

    public Element prepareForm(Element elem) {
        Element form = super.prepareForm(elem);
        Element x = form.getChild("x", "jabber:x:data");
        if (x != null) {
            this.addField(x, CONTAINS_FIELD_NAME, "text-multi", "Contains in body");
            if (this.config.isTagSupportEnabled()) {
                this.addField(x, TAGS_FIELD_NAME, "text-multi", "Contains tags");
            }
        }
        return form;
    }
}

