/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.processors;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.archive.Settings;
import tigase.archive.StoreMethod;
import tigase.archive.processors.MessageArchivePlugin;
import tigase.archive.processors.Xep0313MessageArchiveManagementProcessor;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class Xep0313MessageArchiveManagementProcessorTest
extends ProcessorTestCase {
    private Kernel kernel;
    private MessageArchivePlugin maPlugin;
    private Xep0313MessageArchiveManagementProcessor xep0313Processor;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.kernel = new Kernel();
        this.kernel.registerBean(Xep0313MessageArchiveManagementProcessor.class).setActive(true).exec();
        this.xep0313Processor = (Xep0313MessageArchiveManagementProcessor)this.kernel.getInstance(Xep0313MessageArchiveManagementProcessor.class);
        this.maPlugin = (MessageArchivePlugin)this.kernel.getInstance(MessageArchivePlugin.class);
        Assert.assertNotNull((Object)this.maPlugin);
        this.maPlugin.init(new HashMap());
    }

    @After
    public void tearDown() throws Exception {
        this.xep0313Processor = null;
        this.maPlugin = null;
        this.kernel = null;
        super.tearDown();
    }

    @Test
    public void testChangingPreferencesToAlways() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Settings settings = this.maPlugin.getSettings(session1);
        Assert.assertFalse((String)"Archiving should be disabled by default", (boolean)settings.isAutoArchivingEnabled());
        Element packetEl = new Element("iq");
        packetEl.setAttribute("type", "set");
        packetEl.setAttribute("id", UUID.randomUUID().toString());
        Element prefs = new Element("prefs");
        prefs.setAttribute("xmlns", "urn:xmpp:mam:1");
        prefs.setAttribute("default", "always");
        packetEl.addChild((XMLNodeIfc)prefs);
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque results = new ArrayDeque();
        this.xep0313Processor.process(packet, session1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        Packet result = (Packet)results.poll();
        Assert.assertEquals((Object)"always", (Object)result.getAttributeStaticStr(new String[]{"iq", "prefs"}, "default"));
        Assert.assertTrue((String)"Message archiving should be enabled", (boolean)settings.isAutoArchivingEnabled());
    }

    @Test
    public void testChangingPreferencesToRoster() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Settings settings = this.maPlugin.getSettings(session1);
        Assert.assertFalse((String)"Archiving should be disabled by default", (boolean)settings.isAutoArchivingEnabled());
        Element packetEl = new Element("iq");
        packetEl.setAttribute("type", "set");
        packetEl.setAttribute("id", UUID.randomUUID().toString());
        Element prefs = new Element("prefs");
        prefs.setAttribute("xmlns", "urn:xmpp:mam:1");
        prefs.setAttribute("default", "roster");
        packetEl.addChild((XMLNodeIfc)prefs);
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque results = new ArrayDeque();
        this.xep0313Processor.process(packet, session1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        Packet result = (Packet)results.poll();
        Assert.assertEquals((Object)"roster", (Object)result.getAttributeStaticStr(new String[]{"iq", "prefs"}, "default"));
        Assert.assertTrue((String)"Message archiving should be enabled", (boolean)settings.isAutoArchivingEnabled());
        Assert.assertTrue((String)"Filtering messages by roster contact should be enabled", (boolean)settings.archiveOnlyForContactsInRoster());
    }

    @Test
    public void testChangingPreferencesToNever() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Settings settings = this.maPlugin.getSettings(session1);
        Assert.assertFalse((String)"Archiving should be disabled by default", (boolean)settings.isAutoArchivingEnabled());
        settings.setAuto(true);
        Element packetEl = new Element("iq");
        packetEl.setAttribute("type", "set");
        packetEl.setAttribute("id", UUID.randomUUID().toString());
        Element prefs = new Element("prefs");
        prefs.setAttribute("xmlns", "urn:xmpp:mam:1");
        prefs.setAttribute("default", "never");
        packetEl.addChild((XMLNodeIfc)prefs);
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque results = new ArrayDeque();
        this.xep0313Processor.process(packet, session1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        Packet result = (Packet)results.poll();
        Assert.assertEquals((Object)"never", (Object)result.getAttributeStaticStr(new String[]{"iq", "prefs"}, "default"));
        Assert.assertFalse((String)"Message archiving should be disabled", (boolean)settings.isAutoArchivingEnabled());
    }

    @Test
    public void testChangingPreferencesToRosterWithRequiredStoreMethodMessage() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Field f = MessageArchivePlugin.class.getDeclaredField("globalRequiredStoreMethod");
        f.setAccessible(true);
        f.set(this.maPlugin, StoreMethod.Message);
        Settings settings = this.maPlugin.getSettings(session1);
        Assert.assertTrue((String)"Archiving should be enabled due to store method", (boolean)settings.isAutoArchivingEnabled());
        Element packetEl = new Element("iq");
        packetEl.setAttribute("type", "set");
        packetEl.setAttribute("id", UUID.randomUUID().toString());
        Element prefs = new Element("prefs");
        prefs.setAttribute("xmlns", "urn:xmpp:mam:1");
        prefs.setAttribute("default", "roster");
        packetEl.addChild((XMLNodeIfc)prefs);
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque results = new ArrayDeque();
        this.xep0313Processor.process(packet, session1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        Packet result = (Packet)results.poll();
        Assert.assertEquals((Object)StanzaType.error, (Object)result.getType());
        Assert.assertTrue((String)"Message archiving should be enabled", (boolean)settings.isAutoArchivingEnabled());
        Assert.assertFalse((boolean)settings.archiveOnlyForContactsInRoster());
    }

    @Test
    public void testChangingPreferencesToNeverWithRequiredStoreMethodMessage() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Field f = MessageArchivePlugin.class.getDeclaredField("globalRequiredStoreMethod");
        f.setAccessible(true);
        f.set(this.maPlugin, StoreMethod.Message);
        Settings settings = this.maPlugin.getSettings(session1);
        Assert.assertTrue((String)"Archiving should be enabled due to store method", (boolean)settings.isAutoArchivingEnabled());
        Element packetEl = new Element("iq");
        packetEl.setAttribute("type", "set");
        packetEl.setAttribute("id", UUID.randomUUID().toString());
        Element prefs = new Element("prefs");
        prefs.setAttribute("xmlns", "urn:xmpp:mam:1");
        prefs.setAttribute("default", "never");
        packetEl.addChild((XMLNodeIfc)prefs);
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque results = new ArrayDeque();
        this.xep0313Processor.process(packet, session1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        Packet result = (Packet)results.poll();
        Assert.assertEquals((Object)StanzaType.error, (Object)result.getType());
        Assert.assertTrue((String)"Message archiving should be enabled", (boolean)settings.isAutoArchivingEnabled());
        Assert.assertFalse((boolean)settings.archiveOnlyForContactsInRoster());
    }

    @Test
    public void testForwardingQueriesToComponent() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Element packetEl = new Element("iq");
        packetEl.setAttribute("type", "set");
        packetEl.setAttribute("id", UUID.randomUUID().toString());
        Element prefs = new Element("list");
        prefs.setAttribute("xmlns", "urn:xmpp:mam:1");
        packetEl.addChild((XMLNodeIfc)prefs);
        Packet packet = Packet.packetInstance((Element)packetEl);
        packet.setPacketFrom(session1.getConnectionId());
        ArrayDeque results = new ArrayDeque();
        this.xep0313Processor.process(packet, session1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        Packet result = (Packet)results.poll();
        Assert.assertEquals((Object)StanzaType.set, (Object)result.getType());
        Assert.assertEquals((Object)this.maPlugin.getComponentJid(), (Object)result.getPacketTo());
        packetEl = new Element("iq");
        packetEl.setAttribute("type", "set");
        packetEl.setAttribute("id", UUID.randomUUID().toString());
        prefs = new Element("retrieve");
        prefs.setAttribute("xmlns", "urn:xmpp:mam:1");
        packetEl.addChild((XMLNodeIfc)prefs);
        packet = Packet.packetInstance((Element)packetEl);
        packet.setPacketFrom(session1.getConnectionId());
        results = new ArrayDeque();
        this.xep0313Processor.process(packet, session1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        result = (Packet)results.poll();
        Assert.assertEquals((Object)StanzaType.set, (Object)result.getType());
        Assert.assertEquals((Object)this.maPlugin.getComponentJid(), (Object)result.getPacketTo());
        packetEl = new Element("iq");
        packetEl.setAttribute("type", "set");
        packetEl.setAttribute("id", UUID.randomUUID().toString());
        prefs = new Element("remove");
        prefs.setAttribute("xmlns", "urn:xmpp:mam:1");
        packetEl.addChild((XMLNodeIfc)prefs);
        packet = Packet.packetInstance((Element)packetEl);
        packet.setPacketFrom(session1.getConnectionId());
        results = new ArrayDeque();
        this.xep0313Processor.process(packet, session1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        result = (Packet)results.poll();
        Assert.assertEquals((Object)StanzaType.set, (Object)result.getType());
        Assert.assertEquals((Object)this.maPlugin.getComponentJid(), (Object)result.getPacketTo());
    }
}

