/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.processors;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.archive.MessageArchiveVHostItemExtension;
import tigase.archive.Settings;
import tigase.archive.StoreMethod;
import tigase.archive.processors.MessageArchivePlugin;
import tigase.archive.processors.Xep0136MessageArchivingProcessor;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.vhosts.VHostItemImpl;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class Xep0136MessageArchivingProcessorTest
extends ProcessorTestCase {
    private Kernel kernel;
    private MessageArchivePlugin maPlugin;
    private Xep0136MessageArchivingProcessor xep0136Processor;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.kernel = new Kernel();
        this.kernel.registerBean(Xep0136MessageArchivingProcessor.class).setActive(true).exec();
        this.xep0136Processor = (Xep0136MessageArchivingProcessor)this.kernel.getInstance(Xep0136MessageArchivingProcessor.class);
        this.maPlugin = (MessageArchivePlugin)this.kernel.getInstance(MessageArchivePlugin.class);
        this.maPlugin.init(new HashMap());
    }

    @After
    public void tearDown() throws Exception {
        this.xep0136Processor = null;
        this.maPlugin = null;
        this.kernel = null;
        super.tearDown();
    }

    @Test
    public void testChangingPreferencesEnablingArchiving() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Field f = VHostItemImpl.class.getDeclaredField("extensions");
        f.setAccessible(true);
        Map extensions = (Map)f.get(session1.getDomain());
        extensions.put(MessageArchiveVHostItemExtension.class, MessageArchiveVHostItemExtension.class.newInstance());
        Settings settings = this.maPlugin.getSettings(session1);
        Assert.assertFalse((boolean)settings.isAutoArchivingEnabled());
        Assert.assertEquals((Object)StoreMethod.Body, (Object)settings.getStoreMethod());
        settings.setArchiveOnlyForContactsInRoster(true);
        Element packetEl = new Element("iq");
        packetEl.setAttribute("type", "set");
        packetEl.setAttribute("id", UUID.randomUUID().toString());
        Element pref = new Element("pref");
        pref.setAttribute("xmlns", "urn:xmpp:archive");
        packetEl.addChild((XMLNodeIfc)pref);
        pref.addChild((XMLNodeIfc)new Element("auto", new String[]{"save"}, new String[]{"true"}));
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque results = new ArrayDeque();
        Packet result = null;
        this.xep0136Processor.process(packet, session1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        result = (Packet)results.poll();
        Assert.assertEquals((Object)StanzaType.result, (Object)result.getType());
        Assert.assertTrue((boolean)settings.isAutoArchivingEnabled());
        Assert.assertFalse((boolean)settings.archiveOnlyForContactsInRoster());
    }

    @Test
    public void testChangingPreferencesDisablingArchiving() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Settings settings = this.maPlugin.getSettings(session1);
        Assert.assertFalse((boolean)settings.isAutoArchivingEnabled());
        Assert.assertEquals((Object)StoreMethod.Body, (Object)settings.getStoreMethod());
        settings.setAuto(true);
        settings.setArchiveOnlyForContactsInRoster(true);
        Element packetEl = new Element("iq");
        packetEl.setAttribute("type", "set");
        packetEl.setAttribute("id", UUID.randomUUID().toString());
        Element pref = new Element("pref");
        pref.setAttribute("xmlns", "urn:xmpp:archive");
        packetEl.addChild((XMLNodeIfc)pref);
        pref.addChild((XMLNodeIfc)new Element("auto", new String[]{"save"}, new String[]{"false"}));
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque results = new ArrayDeque();
        Packet result = null;
        this.xep0136Processor.process(packet, session1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        result = (Packet)results.poll();
        Assert.assertEquals((Object)StanzaType.result, (Object)result.getType());
        Assert.assertFalse((boolean)settings.isAutoArchivingEnabled());
        Assert.assertFalse((boolean)settings.archiveOnlyForContactsInRoster());
    }

    @Test
    public void testChangingPreferencesDisablingArchivingWithRequiredStoreMethodMessage() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Field f = MessageArchivePlugin.class.getDeclaredField("globalRequiredStoreMethod");
        f.setAccessible(true);
        f.set(this.maPlugin, StoreMethod.Message);
        Settings settings = this.maPlugin.getSettings(session1);
        Assert.assertTrue((boolean)settings.isAutoArchivingEnabled());
        Assert.assertEquals((Object)StoreMethod.Message, (Object)settings.getStoreMethod());
        Element packetEl = new Element("iq");
        packetEl.setAttribute("type", "set");
        packetEl.setAttribute("id", UUID.randomUUID().toString());
        Element pref = new Element("pref");
        pref.setAttribute("xmlns", "urn:xmpp:archive");
        packetEl.addChild((XMLNodeIfc)pref);
        pref.addChild((XMLNodeIfc)new Element("auto", new String[]{"save"}, new String[]{"false"}));
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque results = new ArrayDeque();
        Packet result = null;
        this.xep0136Processor.process(packet, session1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        result = (Packet)results.poll();
        Assert.assertEquals((Object)StanzaType.error, (Object)result.getType());
        Assert.assertTrue((boolean)settings.isAutoArchivingEnabled());
        Assert.assertFalse((boolean)settings.archiveOnlyForContactsInRoster());
    }

    @Test
    public void testChangingPreferencesChangingStoreMethod() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Settings settings = this.maPlugin.getSettings(session1);
        Assert.assertFalse((boolean)settings.isAutoArchivingEnabled());
        Assert.assertEquals((Object)StoreMethod.Body, (Object)settings.getStoreMethod());
        settings.setAuto(true);
        Element packetEl = new Element("iq");
        packetEl.setAttribute("type", "set");
        packetEl.setAttribute("id", UUID.randomUUID().toString());
        Element pref = new Element("pref");
        pref.setAttribute("xmlns", "urn:xmpp:archive");
        packetEl.addChild((XMLNodeIfc)pref);
        pref.addChild((XMLNodeIfc)new Element("default", new String[]{"save"}, new String[]{"message"}));
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque results = new ArrayDeque();
        Packet result = null;
        this.xep0136Processor.process(packet, session1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        result = (Packet)results.poll();
        Assert.assertEquals((Object)StanzaType.result, (Object)result.getType());
        Assert.assertTrue((boolean)settings.isAutoArchivingEnabled());
        Assert.assertEquals((Object)StoreMethod.Message, (Object)settings.getStoreMethod());
    }

    @Test
    public void testChangingPreferencesChangingStoreMethodWithRequiredStoreMethodMessage() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Field f = MessageArchivePlugin.class.getDeclaredField("globalRequiredStoreMethod");
        f.setAccessible(true);
        f.set(this.maPlugin, StoreMethod.Message);
        Settings settings = this.maPlugin.getSettings(session1);
        Assert.assertTrue((boolean)settings.isAutoArchivingEnabled());
        Assert.assertEquals((Object)StoreMethod.Message, (Object)settings.getStoreMethod());
        settings.setAuto(true);
        Element packetEl = new Element("iq");
        packetEl.setAttribute("type", "set");
        packetEl.setAttribute("id", UUID.randomUUID().toString());
        Element pref = new Element("pref");
        pref.setAttribute("xmlns", "urn:xmpp:archive");
        packetEl.addChild((XMLNodeIfc)pref);
        pref.addChild((XMLNodeIfc)new Element("default", new String[]{"save"}, new String[]{"body"}));
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque results = new ArrayDeque();
        Packet result = null;
        this.xep0136Processor.process(packet, session1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        result = (Packet)results.poll();
        Assert.assertEquals((Object)StanzaType.error, (Object)result.getType());
        Assert.assertTrue((boolean)settings.isAutoArchivingEnabled());
        Assert.assertEquals((Object)StoreMethod.Message, (Object)settings.getStoreMethod());
    }

    @Test
    public void testForwardingQueriesToComponent() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Element packetEl = new Element("iq");
        packetEl.setAttribute("type", "set");
        packetEl.setAttribute("id", UUID.randomUUID().toString());
        Element prefs = new Element("list");
        prefs.setAttribute("xmlns", "urn:xmpp:archive");
        packetEl.addChild((XMLNodeIfc)prefs);
        Packet packet = Packet.packetInstance((Element)packetEl);
        packet.setPacketFrom(session1.getConnectionId());
        ArrayDeque results = new ArrayDeque();
        this.xep0136Processor.process(packet, session1, null, results, null);
        Assert.assertEquals((long)1L, (long)results.size());
        Packet result = (Packet)results.poll();
        Assert.assertEquals((Object)StanzaType.set, (Object)result.getType());
        Assert.assertEquals((Object)this.maPlugin.getComponentJid(), (Object)result.getPacketTo());
    }
}

