/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.db;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import tigase.archive.MessageArchiveComponent;
import tigase.archive.QueryCriteria;
import tigase.archive.db.MessageArchiveRepository;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.TigaseDBException;
import tigase.db.beans.MDRepositoryBean;
import tigase.db.beans.MDRepositoryBeanWithStatistics;
import tigase.kernel.beans.Bean;
import tigase.server.BasicComponent;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.Query;

@Bean(name="repositoryPool", parent=MessageArchiveComponent.class, active=true)
public class MessageArchiveRepositoryPool<Q extends QueryCriteria, R extends MessageArchiveRepository<Q, DataSource>>
extends MDRepositoryBeanWithStatistics<R>
implements MessageArchiveRepository<Q, DataSource> {
    public MessageArchiveRepositoryPool() {
        super(new Class[]{MessageArchiveRepository.class, MAMRepository.class});
    }

    public MessageArchiveRepositoryPool(Class<? extends MessageArchiveRepository> ... classess) {
        super((Class[])Stream.concat(Stream.of(classess), Stream.of(MessageArchiveRepository.class, MAMRepository.class)).toArray(Class[]::new));
    }

    public boolean belongsTo(Class<? extends BasicComponent> component) {
        return MessageArchiveComponent.class.isAssignableFrom(component);
    }

    @Override
    public void archiveMessage(BareJID owner, JID buddy, MessageArchiveRepository.Direction direction, Date timestamp, Element msg, Set tags) {
        ((MessageArchiveRepository)this.getRepository(owner.getDomain())).archiveMessage(owner, buddy, direction, timestamp, msg, tags);
    }

    @Override
    public void deleteExpiredMessages(BareJID owner, LocalDateTime before) throws TigaseDBException {
        ((MessageArchiveRepository)this.getRepository(owner.getDomain())).deleteExpiredMessages(owner, before);
    }

    public Q newQuery() {
        return (Q)((QueryCriteria)((MessageArchiveRepository)this.getRepository("default")).newQuery());
    }

    @Override
    public void queryCollections(Q query, MessageArchiveRepository.CollectionHandler<Q> collectionHandler) throws TigaseDBException {
        ((MessageArchiveRepository)this.getRepository(query.getQuestionerJID().getDomain())).queryCollections(query, collectionHandler);
    }

    public void queryItems(Q query, MAMRepository.ItemHandler<Q, MAMRepository.Item> itemHandler) throws RepositoryException, ComponentException {
        ((MessageArchiveRepository)this.getRepository(query.getQuestionerJID().getDomain())).queryItems((Query)query, (MAMRepository.ItemHandler)itemHandler);
    }

    @Override
    public void removeItems(BareJID owner, String withJid, Date start, Date end) throws TigaseDBException {
        ((MessageArchiveRepository)this.getRepository(owner.getDomain())).removeItems(owner, withJid, start, end);
    }

    @Override
    public List<String> getTags(BareJID owner, String startsWith, Q criteria) throws TigaseDBException {
        return ((MessageArchiveRepository)this.getRepository(owner.getDomain())).getTags(owner, startsWith, criteria);
    }

    public void setDataSource(DataSource dataSource) {
    }

    public Class<?> getDefaultBeanClass() {
        return MessageArchiveRepositoryConfigBean.class;
    }

    protected Class findClassForDataSource(DataSource dataSource) throws DBInitException {
        return DataSourceHelper.getDefaultClass(MessageArchiveRepository.class, (String)dataSource.getResourceUri());
    }

    public static class MessageArchiveRepositoryConfigBean
    extends MDRepositoryBean.MDRepositoryConfigBean<MessageArchiveRepository<QueryCriteria, DataSource>> {
    }
}

