/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.db;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Set;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.TigaseDBException;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.Query;

public interface MessageArchiveRepository<Q extends tigase.archive.xep0136.Query, DS extends DataSource>
extends DataSourceAware<DS>,
MAMRepository<Q, MAMRepository.Item> {
    public void archiveMessage(BareJID var1, JID var2, Direction var3, Date var4, Element var5, Set<String> var6);

    public void deleteExpiredMessages(BareJID var1, LocalDateTime var2) throws TigaseDBException;

    default public void destroy() {
    }

    public void removeItems(BareJID var1, String var2, Date var3, Date var4) throws TigaseDBException;

    public List<String> getTags(BareJID var1, String var2, Q var3) throws TigaseDBException;

    public void queryCollections(Q var1, CollectionHandler<Q> var2) throws TigaseDBException;

    public static interface Item
    extends MAMRepository.Item {
        public Direction getDirection();

        public String getWith();
    }

    public static interface CollectionHandler<Q extends Query> {
        public void collectionFound(Q var1, String var2, Date var3, String var4);
    }

    public static enum Direction {
        incoming(1, "from"),
        outgoing(0, "to");

        private final String elemName;
        private final short value;

        public static Direction getDirection(BareJID owner, BareJID from) {
            return owner.equals((Object)from) ? outgoing : incoming;
        }

        public static Direction getDirection(short val) {
            switch (val) {
                case 1: {
                    return incoming;
                }
                case 0: {
                    return outgoing;
                }
            }
            return null;
        }

        public static Direction getDirection(String val) {
            if (incoming.toElementName().equals(val)) {
                return incoming;
            }
            if (outgoing.toElementName().equals(val)) {
                return outgoing;
            }
            return null;
        }

        private Direction(short val, String elemName) {
            this.value = val;
            this.elemName = elemName;
        }

        public short getValue() {
            return this.value;
        }

        public String toElementName() {
            return this.elemName;
        }
    }
}

