/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive.processors;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.archive.Settings;
import tigase.archive.processors.MessageArchivePlugin;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class MessageArchivePluginTest
extends ProcessorTestCase {
    private static final Logger log = Logger.getLogger(MessageArchivePluginTest.class.getCanonicalName());
    private Kernel kernel;
    private MessageArchivePlugin messageArchivePlugin;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.kernel = new Kernel();
        this.kernel.registerBean(MessageArchivePlugin.class).setActive(true).exec();
        this.messageArchivePlugin = (MessageArchivePlugin)this.kernel.getInstance(MessageArchivePlugin.class);
        this.messageArchivePlugin.init(new HashMap());
    }

    @After
    public void tearDown() throws Exception {
        this.messageArchivePlugin = null;
        super.tearDown();
    }

    @Test
    public void testXEP0334_MessageHints() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Settings settings = new Settings();
        session1.putCommonSessionData("message-archive/settings", (Object)settings);
        ArrayDeque results = new ArrayDeque();
        settings.setAuto(true);
        Packet packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("body", "Test message 123")}, new String[]{"from", "to"}, new String[]{"from@example.com/res1", "to@example.com/res2"}));
        this.messageArchivePlugin.process(packet, session1, null, results, null);
        Assert.assertFalse((String)("should sent packet " + packet + " for storage"), (boolean)results.isEmpty());
        results.clear();
        packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("body", "Test message 123"), new Element("no-store", new String[]{"xmlns"}, new String[]{"urn:xmpp:hints"})}, new String[]{"from", "to"}, new String[]{"from@example.com/res1", "to@example.com/res2"}));
        this.messageArchivePlugin.process(packet, session1, null, results, null);
        Assert.assertTrue((String)("should not sent packet " + packet + " for storage"), (boolean)results.isEmpty());
        results.clear();
        packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("body", "Test message 123"), new Element("no-permanent-store", new String[]{"xmlns"}, new String[]{"urn:xmpp:hints"})}, new String[]{"from", "to"}, new String[]{"from@example.com/res1", "to@example.com/res2"}));
        this.messageArchivePlugin.process(packet, session1, null, results, null);
        Assert.assertTrue((String)("should not sent packet " + packet + " for storage"), (boolean)results.isEmpty());
    }

    @Test
    public void testXEP0313_IngoringArchivizationMessagesRetrievedFromRepository() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        Settings settings = new Settings();
        session1.putCommonSessionData("message-archive/settings", (Object)settings);
        ArrayDeque results = new ArrayDeque();
        settings.setAuto(true);
        Packet packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("result", new Element[]{new Element("forwarded", new Element[]{new Element("message", new Element[]{new Element("body", "Test body messages")}, new String[]{"from", "to"}, new String[]{"user2@example.com", "user1@example.com"})}, new String[]{"xmlns"}, new String[]{"urn:xmpp:forward:0"})}, new String[]{"xmlns", "queryid", "id"}, new String[]{"urn:xmpp:mam:1", "g28", "28428-20978-43925"})}, new String[]{"from", "to"}, new String[]{"from@example.com/res1", "to@example.com/res2"}));
        this.messageArchivePlugin.process(packet, session1, null, results, null);
        Assert.assertTrue((String)("should not sent packet " + packet + " for storage"), (boolean)results.isEmpty());
    }
}

