/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.archive.StoreMethod;
import tigase.archive.VHostItemHelper;
import tigase.db.TigaseDBException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;

public class Settings {
    private static final Logger log = Logger.getLogger(Settings.class.getCanonicalName());

    public static boolean getAutoSave(XMPPResourceConnection session, StoreMethod globalRequiredStoreMethod) throws NotAuthorizedException {
        StoreMethod requiredStoreMethod = Settings.getRequiredStoreMethod(session, globalRequiredStoreMethod);
        if (requiredStoreMethod != StoreMethod.False) {
            return true;
        }
        Boolean auto = (Boolean)session.getCommonSessionData("message-archive-xep-0136/auto");
        if (auto == null) {
            try {
                String data = session.getData("message-archive/settings", "auto", "false");
                auto = Boolean.parseBoolean(data);
                if (!VHostItemHelper.isEnabled(session.getDomain()) && auto.booleanValue()) {
                    auto = false;
                    session.setData("message-archive/settings", "auto", String.valueOf(auto));
                }
                session.putCommonSessionData("message-archive-xep-0136/auto", (Object)auto);
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Error getting Message Archive state: {0}", ex.getMessage());
                auto = false;
            }
        }
        return auto;
    }

    protected static StoreMethod getRequiredStoreMethod(XMPPResourceConnection session, StoreMethod globalRequiredStoreMethod) {
        return StoreMethod.valueof(VHostItemHelper.getRequiredStoreMethod(session.getDomain(), globalRequiredStoreMethod.toString()));
    }
}

