/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import tigase.archive.MessageArchiveComponent;
import tigase.archive.MessageArchivePlugin;
import tigase.archive.db.JDBCMessageArchiveRepository;
import tigase.osgi.ModulesManager;

public class Activator
implements BundleActivator,
ServiceListener {
    private static final Logger log = Logger.getLogger(Activator.class.getCanonicalName());
    private Class<MessageArchivePlugin> archivePluginClass = null;
    private Class<MessageArchiveComponent> archiveComponentClass = null;
    private BundleContext context = null;
    private ServiceReference serviceReference = null;
    private ModulesManager serviceManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bc) throws Exception {
        Activator activator = this;
        synchronized (activator) {
            this.context = bc;
            bc.addServiceListener((ServiceListener)this, "(&(objectClass=" + ModulesManager.class.getName() + "))");
            this.archivePluginClass = MessageArchivePlugin.class;
            this.archiveComponentClass = MessageArchiveComponent.class;
            this.serviceReference = bc.getServiceReference(ModulesManager.class.getName());
            if (this.serviceReference != null) {
                this.serviceManager = (ModulesManager)bc.getService(this.serviceReference);
                this.registerAddons();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bc) throws Exception {
        Activator activator = this;
        synchronized (activator) {
            if (this.serviceManager != null) {
                this.unregisterAddons();
                this.context.ungetService(this.serviceReference);
                this.serviceManager = null;
                this.serviceReference = null;
            }
            this.archivePluginClass = null;
            this.archiveComponentClass = null;
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            if (this.serviceReference == null) {
                this.serviceReference = event.getServiceReference();
                this.serviceManager = (ModulesManager)this.context.getService(this.serviceReference);
                this.registerAddons();
            }
        } else if (event.getType() == 4 && this.serviceReference == event.getServiceReference()) {
            this.unregisterAddons();
            this.context.ungetService(this.serviceReference);
            this.serviceManager = null;
            this.serviceReference = null;
        }
    }

    private void registerAddons() {
        if (this.serviceManager != null) {
            this.serviceManager.registerPluginClass(this.archivePluginClass);
            this.serviceManager.registerServerComponentClass(this.archiveComponentClass);
            this.serviceManager.registerClass(JDBCMessageArchiveRepository.class);
            this.serviceManager.update();
        }
    }

    private void unregisterAddons() {
        if (this.serviceManager != null) {
            this.serviceManager.unregisterPluginClass(this.archivePluginClass);
            this.serviceManager.unregisterServerComponentClass(this.archiveComponentClass);
            this.serviceManager.unregisterClass(JDBCMessageArchiveRepository.class);
            this.serviceManager.update();
        }
    }
}

