/*
 * Decompiled with CFR 0.152.
 */
package tigase.archive;

import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tigase.archive.TagsHelper;
import tigase.archive.TimestampHelper;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.RSM;

public abstract class AbstractCriteria<D extends Date> {
    private static final String CONTAINS = "contains";
    private static final String TAG = "tag";
    private static final String NAME = "query";
    public static final String ARCHIVE_XMLNS = "urn:xmpp:archive";
    public static final String QUERTY_XMLNS = "http://tigase.org/protocol/archive#query";
    private String with = null;
    private D start = null;
    private D end = null;
    private final RSM rsm = new RSM();
    private int index = 0;
    private int limit = 0;
    private final Set<String> contains = new HashSet<String>();
    private final Set<String> tags = new HashSet<String>();

    public AbstractCriteria fromElement(Element el, boolean tagsSupport) throws IllegalArgumentException, ParseException {
        List children;
        if (el.getXMLNS() != ARCHIVE_XMLNS) {
            throw new IllegalArgumentException("Not supported XMLNS of element");
        }
        this.rsm.fromElement(el);
        this.with = el.getAttributeStaticStr("with");
        this.start = this.convertTimestamp(TimestampHelper.parseTimestamp(el.getAttributeStaticStr("start")));
        this.end = this.convertTimestamp(TimestampHelper.parseTimestamp(el.getAttributeStaticStr("end")));
        Element query = el.getChild(NAME, QUERTY_XMLNS);
        if (query != null && (children = query.getChildren()) != null) {
            for (Element child : children) {
                String cdata = null;
                switch (child.getName()) {
                    case "contains": {
                        cdata = child.getCData();
                        if (cdata == null) break;
                        this.contains.add(cdata);
                        if (!tagsSupport) break;
                        TagsHelper.extractTags(this.tags, cdata);
                        break;
                    }
                    case "tag": {
                        cdata = child.getCData();
                        if (cdata == null) break;
                        this.tags.add(cdata.trim());
                    }
                }
            }
        }
        return this;
    }

    public Set<String> getContains() {
        return Collections.unmodifiableSet(this.contains);
    }

    public void addContains(String contain) {
        this.contains.add(contain);
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public RSM getRSM() {
        return this.rsm;
    }

    public String getWith() {
        return this.with;
    }

    public void setWith(String with) {
        this.with = with;
    }

    public D getStart() {
        return this.start;
    }

    public D getEnd() {
        return this.end;
    }

    public void setStart(Date start) {
        this.start = this.convertTimestamp(start);
    }

    public void setEnd(Date end) {
        this.end = this.convertTimestamp(end);
    }

    public int getOffset() {
        return this.index;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setSize(int count) {
        this.index = this.rsm.getIndex() == null ? 0 : this.rsm.getIndex();
        this.limit = this.rsm.getMax();
        if (this.rsm.getAfter() != null) {
            int after = Integer.parseInt(this.rsm.getAfter());
            this.index = after + 1;
        } else if (this.rsm.getBefore() != null) {
            int before = Integer.parseInt(this.rsm.getBefore());
            this.index = before - this.rsm.getMax();
            if (this.index < 0) {
                this.index = 0;
                this.limit = before;
            }
        } else if (this.rsm.hasBefore()) {
            this.index = count - this.rsm.getMax();
            if (this.index < 0) {
                this.index = 0;
            }
        }
    }

    public void prepareResult(Element retList) {
        RSM rsm = this.getRSM();
        if (rsm.getCount() == null || rsm.getCount() != 0) {
            retList.addChild((XMLNodeIfc)rsm.toElement());
        }
    }

    protected abstract D convertTimestamp(Date var1);
}

