/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import tigase.meet.jingle.Candidate;
import tigase.meet.jingle.Fingerprint;
import tigase.xml.Element;

public class Transport {
    private final Optional<String> ufrag;
    private final Optional<String> pwd;
    private final List<Candidate> candidates;
    private final Optional<Fingerprint> fingerprint;

    public static Transport from(Element el) {
        if ("transport".equals(el.getName())) {
            Optional<String> ufrag = Optional.ofNullable(el.getAttributeStaticStr("ufrag"));
            Optional<String> pwd = Optional.ofNullable(el.getAttributeStaticStr("pwd"));
            List children = Optional.ofNullable(el.getChildren()).orElse(Collections.emptyList());
            Optional<Fingerprint> fingerprint = children.stream().map(Fingerprint::from).filter(Objects::nonNull).findFirst();
            List<Candidate> candidates = children.stream().map(Candidate::from).filter(Objects::nonNull).collect(Collectors.toList());
            return new Transport(ufrag, pwd, candidates, fingerprint);
        }
        return null;
    }

    public Transport(Optional<String> ufrag, Optional<String> pwd, List<Candidate> candidates, Optional<Fingerprint> fingerprint) {
        this.ufrag = ufrag;
        this.pwd = pwd;
        this.candidates = candidates;
        this.fingerprint = fingerprint;
    }

    public Optional<String> getUfrag() {
        return this.ufrag;
    }

    public Optional<String> getPwd() {
        return this.pwd;
    }

    public List<Candidate> getCandidates() {
        return this.candidates;
    }

    public Optional<Fingerprint> getFingerprint() {
        return this.fingerprint;
    }

    public Element toElement() {
        Element el = new Element("transport");
        el.setXMLNS("urn:xmpp:jingle:transports:ice-udp:1");
        this.fingerprint.map(Fingerprint::toElement).ifPresent(arg_0 -> ((Element)el).addChild(arg_0));
        this.candidates.stream().map(Candidate::toElement).forEach(arg_0 -> ((Element)el).addChild(arg_0));
        this.ufrag.ifPresent(ufrag -> el.setAttribute("ufrag", ufrag));
        this.pwd.ifPresent(pwd -> el.setAttribute("pwd", pwd));
        return el;
    }
}

