/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import tigase.meet.jingle.Encryption;
import tigase.meet.jingle.HdrExt;
import tigase.meet.jingle.Payload;
import tigase.meet.jingle.SSRC;
import tigase.meet.jingle.SSRCGroup;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class Description {
    private final String media;
    private final Optional<String> ssrc;
    private final List<Payload> payloads;
    private final Optional<String> bandwidth;
    private final List<Encryption> encryptions;
    private final boolean rtcpMux;
    private final List<SSRC> ssrcs;
    private final List<SSRCGroup> ssrcGroups;
    private final List<HdrExt> hdrExts;

    public static Description from(Element el) {
        return Description.from(el, true);
    }

    public static Description from(Element el, boolean ignoreSRTP) {
        if ("description".equals(el.getName()) && "urn:xmpp:jingle:apps:rtp:1".equals(el.getXMLNS())) {
            String media = el.getAttributeStaticStr("media");
            if (media == null) {
                return null;
            }
            Optional<String> ssrc = Optional.ofNullable(el.getAttributeStaticStr("ssrc"));
            List children = Optional.ofNullable(el.getChildren()).orElse(Collections.emptyList());
            List<Payload> payloads = children.stream().map(Payload::from).filter(Objects::nonNull).collect(Collectors.toList());
            Optional<String> bandwidth = Optional.ofNullable(el.getChild("bandwidth")).map(it -> it.getAttributeStaticStr("type"));
            boolean rtcpMux = el.getChild("rtcp-mux") != null;
            List<Encryption> encryptions = ignoreSRTP ? Collections.emptyList() : Optional.ofNullable(el.getChild("encryption")).map(it -> it.getChildren()).orElse(Collections.emptyList()).stream().map(Encryption::from).filter(Objects::nonNull).collect(Collectors.toList());
            List<SSRC> ssrcs = children.stream().map(SSRC::from).filter(Objects::nonNull).collect(Collectors.toList());
            List<SSRCGroup> ssrcGroups = children.stream().map(SSRCGroup::from).filter(Objects::nonNull).collect(Collectors.toList());
            List<HdrExt> hdrExts = children.stream().map(HdrExt::from).filter(Objects::nonNull).collect(Collectors.toList());
            return new Description(media, ssrc, payloads, bandwidth, encryptions, rtcpMux, ssrcs, ssrcGroups, hdrExts);
        }
        return null;
    }

    public Description(String media, Optional<String> ssrc, List<Payload> payloads, Optional<String> bandwidth, List<Encryption> encryptions, boolean rtcpMux, List<SSRC> ssrcs, List<SSRCGroup> ssrcGroups, List<HdrExt> hdrExts) {
        this.media = media;
        this.ssrc = ssrc;
        this.payloads = payloads;
        this.bandwidth = bandwidth;
        this.encryptions = encryptions;
        this.rtcpMux = rtcpMux;
        this.ssrcs = ssrcs;
        this.ssrcGroups = ssrcGroups;
        this.hdrExts = hdrExts;
    }

    public String getMedia() {
        return this.media;
    }

    public Optional<String> getSsrc() {
        return this.ssrc;
    }

    public List<Payload> getPayloads() {
        return this.payloads;
    }

    public Optional<String> getBandwidth() {
        return this.bandwidth;
    }

    public List<Encryption> getEncryptions() {
        return this.encryptions;
    }

    public boolean isRtcpMux() {
        return this.rtcpMux;
    }

    public List<SSRC> getSsrcs() {
        return this.ssrcs;
    }

    public List<SSRCGroup> getSsrcGroups() {
        return this.ssrcGroups;
    }

    public List<HdrExt> getHdrExts() {
        return this.hdrExts;
    }

    public Description cloneWithSSRCsOnly() {
        return new Description(this.media, this.ssrc, Collections.emptyList(), Optional.empty(), Collections.emptyList(), false, this.ssrcs, this.ssrcGroups, Collections.emptyList());
    }

    public Description withSSRCs(List<SSRC> ssrcs, List<SSRCGroup> ssrcGroups) {
        return new Description(this.media, this.ssrc, this.payloads, this.bandwidth, this.encryptions, this.rtcpMux, ssrcs, ssrcGroups, this.hdrExts);
    }

    public Element toElement() {
        return this.toElement(true);
    }

    public Element toElement(boolean ignoreSRTP) {
        Element el = new Element("description");
        el.setXMLNS("urn:xmpp:jingle:apps:rtp:1");
        el.setAttribute("media", this.media);
        if (this.rtcpMux) {
            el.addChild((XMLNodeIfc)new Element("rtcp-mux"));
        }
        this.ssrc.ifPresent(ssrc -> el.setAttribute("ssrc", ssrc));
        this.payloads.stream().map(Payload::toElement).forEach(arg_0 -> ((Element)el).addChild(arg_0));
        if (!ignoreSRTP && !this.encryptions.isEmpty()) {
            Element encryption = new Element("encryption");
            this.encryptions.stream().map(Encryption::toElement).forEach(arg_0 -> ((Element)encryption).addChild(arg_0));
            el.addChild((XMLNodeIfc)encryption);
        }
        this.ssrcGroups.stream().map(SSRCGroup::toElement).forEach(arg_0 -> ((Element)el).addChild(arg_0));
        this.ssrcs.stream().map(SSRC::toElement).forEach(arg_0 -> ((Element)el).addChild(arg_0));
        this.hdrExts.stream().map(HdrExt::toElement).forEach(arg_0 -> ((Element)el).addChild(arg_0));
        return el;
    }

    public static enum Senders {
        initiator,
        responder,
        both;

    }
}

