/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.JanusPlugin;

public class JanusSession {
    private static final Logger log = Logger.getLogger(JanusSession.class.getCanonicalName());
    private final JanusConnection connection;
    private final long sessionId;
    private ScheduledFuture<?> keepAliveFuture;
    private final ConcurrentHashMap<Long, JanusPlugin> attachedPlugins = new ConcurrentHashMap();

    protected JanusSession(JanusConnection connection, Map<String, Object> sessionData) {
        if (sessionData == null) {
            throw new IllegalArgumentException("Missing 'sessionData'!");
        }
        Long id = (Long)sessionData.get("id");
        if (id == null) {
            throw new IllegalArgumentException("Missing session id!");
        }
        this.connection = connection;
        this.sessionId = id;
    }

    public JanusConnection getConnection() {
        return this.connection;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String nextTransactionId() {
        return this.connection.nextTransactionId();
    }

    public String logPrefix() {
        return this.connection.logPrefix() + ", session " + this.getSessionId();
    }

    public String logPrefix(String transaction) {
        return this.connection.logPrefix(transaction) + ", session " + this.getSessionId();
    }

    public void handleEvent(Map<String, Object> event) {
        Long senderId = (Long)event.get("sender");
        if (senderId != null) {
            JanusPlugin plugin = this.attachedPlugins.get(senderId);
            if (plugin != null) {
                Object content = plugin.extractData(event);
                plugin.handleEvent(content);
            } else {
                log.log(Level.WARNING, () -> this.logPrefix() + ", received event from unknown sender: " + senderId + ", values: " + event);
            }
        } else {
            log.log(Level.WARNING, () -> this.logPrefix() + ", received event from without sender, values: " + event);
        }
    }

    public void handleTrickle(Map<String, Object> trickle) {
        Long senderId = (Long)trickle.get("sender");
        if (senderId != null) {
            JanusPlugin plugin = this.attachedPlugins.get(senderId);
            if (plugin != null) {
                plugin.handleTrickle(trickle);
            } else {
                log.log(Level.WARNING, () -> this.logPrefix() + ", received trickle from unknown sender: " + senderId + ", values: " + trickle);
            }
        } else {
            log.log(Level.WARNING, () -> this.logPrefix() + ", received trickle from without sender, values: " + trickle);
        }
    }

    public CompletableFuture<Map<String, Object>> execute(String janus, String transaction, JanusConnection.RequestGenerator requestGenerator) {
        return this.connection.execute(janus, transaction, generator -> {
            generator.writeNumberField("session_id", this.sessionId);
            requestGenerator.accept(generator);
        });
    }

    public CompletableFuture<Void> send(String janus, String transaction, JanusConnection.RequestGenerator requestGenerator) {
        return this.connection.send(janus, transaction, generator -> {
            generator.writeNumberField("session_id", this.sessionId);
            requestGenerator.accept(generator);
        });
    }

    public <T extends JanusPlugin> CompletableFuture<T> attachPlugin(Class<T> pluginClass) {
        String transaction = this.nextTransactionId();
        String pluginId = this.connection.getPluginId(pluginClass);
        log.log(Level.FINER, () -> this.logPrefix(transaction) + ", attaching plugin " + pluginId + " with class " + pluginClass.getCanonicalName() + "...");
        return ((CompletableFuture)this.execute("attach", transaction, generator -> generator.writeStringField("plugin", pluginId)).thenApply(data -> JanusPlugin.newInstance(pluginClass, this, (Map)data.get("data")))).whenComplete((plugin, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.logPrefix(transaction) + ", plugin " + pluginId + " with class " + pluginClass.getCanonicalName() + " attachment failed.");
            } else {
                log.log(Level.FINER, () -> this.logPrefix(transaction) + ", plugin " + plugin + " attached.");
                this.attachedPlugins.put(plugin.getHandleId(), (JanusPlugin)plugin);
            }
        });
    }

    public CompletableFuture<Void> detachPlugin(JanusPlugin plugin) {
        String transaction = this.nextTransactionId();
        log.log(Level.FINER, () -> this.logPrefix(transaction) + ", detaching plugin " + plugin + "...");
        return ((CompletableFuture)this.execute("detach", transaction, generator -> generator.writeNumberField("handle_id", plugin.getHandleId())).whenComplete((x, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.logPrefix(transaction) + ", plugin " + plugin + " detachment failed.");
            } else {
                log.log(Level.FINER, () -> this.logPrefix(transaction) + ", plugin " + plugin.toString() + " detached.");
                if (this.keepAliveFuture != null) {
                    this.keepAliveFuture.cancel(false);
                }
                this.attachedPlugins.remove(plugin.getHandleId());
            }
        })).thenApply(x -> null);
    }

    public CompletableFuture<Void> keepAlive() {
        return this.send("keepalive", this.nextTransactionId(), generator -> {});
    }

    public void scheduleKeepAlive(ScheduledExecutorService executorService, Duration sessionTimeout) {
        if (this.keepAliveFuture != null) {
            this.keepAliveFuture.cancel(false);
        }
        long timeout = sessionTimeout.minusSeconds(5L).toMillis();
        this.keepAliveFuture = executorService.scheduleAtFixedRate(this::keepAlive, timeout, timeout, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<Void> destroy() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        CompletableFuture.allOf((CompletableFuture[])this.attachedPlugins.values().stream().map(plugin -> this.detachPlugin((JanusPlugin)plugin)).toArray(CompletableFuture[]::new)).whenComplete((x, ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            } else {
                this.connection.destroySession(this).whenComplete((x1, ex1) -> {
                    if (ex1 != null) {
                        future.completeExceptionally((Throwable)ex1);
                    } else {
                        future.complete(null);
                    }
                });
            }
        });
        return future;
    }
}

