/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import tigase.meet.janus.JSEP;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.JanusException;
import tigase.meet.janus.JanusSession;

public abstract class JanusPlugin<T extends Content> {
    private final JanusSession session;
    private final long handleId;

    public static <T extends JanusPlugin> T newInstance(Class<T> pluginClass, JanusSession session, Map<String, Object> data) {
        try {
            return (T)((JanusPlugin)pluginClass.getDeclaredConstructor(JanusSession.class, Map.class).newInstance(session, data));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalArgumentException("Class " + pluginClass + " does not contain required constructor!", ex);
        }
    }

    protected JanusPlugin(JanusSession session, Map<String, Object> data) {
        if (data == null) {
            throw new IllegalArgumentException("Missing 'data'!");
        }
        Long id = (Long)data.get("id");
        if (id == null) {
            throw new IllegalArgumentException("Missing handle id!");
        }
        this.session = session;
        this.handleId = id;
    }

    public abstract String getId();

    public abstract void handleEvent(T var1);

    public void handleTrickle(Map<String, Object> trickle) {
        List list = (List)trickle.get("candidates");
        if (list != null) {
            for (Map map : list) {
                if (map.containsKey("completed")) continue;
                this.receivedCandidate(Candidate.fromMap(map));
            }
        } else {
            Object map = trickle.get("candidate");
            if (map instanceof Map && !((Map)map).containsKey("completed")) {
                this.receivedCandidate(Candidate.fromMap((Map)map));
            }
        }
    }

    protected abstract void receivedCandidate(Candidate var1);

    public JanusSession getSession() {
        return this.session;
    }

    public long getHandleId() {
        return this.handleId;
    }

    public CompletableFuture<T> execute(String transaction, JanusConnection.RequestGenerator bodyGenerator, JSEP jsep) {
        return this.session.execute("message", transaction, (JsonGenerator generator) -> {
            generator.writeNumberField("handle_id", this.handleId);
            if (bodyGenerator != null) {
                generator.writeFieldName("body");
                generator.writeStartObject();
                bodyGenerator.accept(generator);
                generator.writeEndObject();
            }
            if (jsep != null) {
                jsep.write(generator);
            }
        }).thenApply(this::extractData);
    }

    public CompletableFuture<Void> sendMessage(String transaction, JanusConnection.RequestGenerator bodyGenerator, JSEP jsep) {
        return this.session.send("message", transaction, generator -> {
            generator.writeNumberField("handle_id", this.handleId);
            if (bodyGenerator != null) {
                generator.writeFieldName("body");
                generator.writeStartObject();
                bodyGenerator.accept(generator);
                generator.writeEndObject();
            }
            if (jsep != null) {
                jsep.write(generator);
            }
        }).thenApply(x -> null);
    }

    public CompletableFuture<Void> sendTrickle(String transaction, JanusConnection.RequestGenerator bodyGenerator) {
        return this.session.send("trickle", transaction, generator -> {
            generator.writeNumberField("handle_id", this.handleId);
            bodyGenerator.accept(generator);
        });
    }

    public CompletableFuture<Void> sendTrickle(String transaction, Candidate candidate) {
        return this.sendTrickle(transaction, (JsonGenerator generator) -> {
            generator.writeFieldName("candidate");
            candidate.write(generator);
        });
    }

    public CompletableFuture<Void> detach() {
        return this.session.detachPlugin(this);
    }

    protected T extractData(Map<String, Object> response) {
        Map plugindata = (Map)response.get("plugindata");
        if (plugindata == null) {
            throw new NullPointerException("Received JSON with 'plugindata' not set!");
        }
        if (!this.getId().equals(plugindata.get("plugin"))) {
            throw new IllegalArgumentException("Received data by plugin " + this.getId() + " sent for " + plugindata.get("plugin"));
        }
        Map data = (Map)plugindata.get("data");
        if (data == null) {
            throw new NullPointerException("Missing 'data' for plugin!");
        }
        this.assertNotError(data);
        return this.newContent(data, JSEP.fromData(response));
    }

    protected abstract T newContent(Map<String, Object> var1, JSEP var2);

    protected void assertNotError(Map<String, Object> data) {
        Integer errorCode = (Integer)data.get("error_code");
        if (errorCode != null) {
            throw new JanusException(errorCode, (String)data.get("error"));
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{session=" + this.session.getSessionId() + ", handleId=" + this.handleId + "}";
    }

    public static class Candidate {
        private final String mid;
        private final int sdpMLineIndex;
        private final String candidate;

        public static final Candidate fromMap(Map<String, Object> data) {
            return new Candidate((String)data.get("sdpMid"), ((Number)data.get("sdpMLineIndex")).intValue(), (String)data.get("candidate"));
        }

        public Candidate(String mid, int sdpMLineIndex, String candidate) {
            this.mid = mid;
            this.sdpMLineIndex = sdpMLineIndex;
            this.candidate = candidate;
        }

        public String getMid() {
            return this.mid;
        }

        public int getSdpMLineIndex() {
            return this.sdpMLineIndex;
        }

        public String getCandidate() {
            return this.candidate;
        }

        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("sdpMid", this.mid);
            generator.writeNumberField("sdpMLineIndex", this.sdpMLineIndex);
            generator.writeStringField("candidate", this.candidate);
            generator.writeEndObject();
        }

        public String toString() {
            return "Candidate{mid='" + this.mid + "', sdpMLineIndex=" + this.sdpMLineIndex + ", candidate='" + this.candidate + "'}";
        }
    }

    public static class Content {
        public final Map<String, Object> data;
        public final JSEP jsep;

        public Content(Map<String, Object> data, JSEP jsep) {
            this.data = data;
            this.jsep = jsep;
        }
    }
}

