/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.component.exceptions.ComponentException;
import tigase.meet.AbstractParticipationWithSession;
import tigase.meet.Meet;
import tigase.meet.janus.JSEP;
import tigase.meet.janus.JanusPlugin;
import tigase.meet.janus.videoroom.LocalPublisher;
import tigase.meet.janus.videoroom.LocalSubscriber;
import tigase.meet.janus.videoroom.Publisher;
import tigase.meet.jingle.Candidate;
import tigase.meet.jingle.Content;
import tigase.meet.jingle.ContentAction;
import tigase.meet.jingle.SDP;
import tigase.meet.jingle.Transport;
import tigase.meet.utils.DelayedRunQueue;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

public class Participation
extends AbstractParticipationWithSession<Participation, Meet> {
    private static final Logger log = Logger.getLogger(Participation.class.getCanonicalName());
    private final Content.Creator localPublisherRole = Content.Creator.responder;
    private final Content.Creator localSubscriberRole = Content.Creator.initiator;
    private SDPHolder localPublisherSDP;
    private SDPHolder localSubscriberSDP;
    private SDPHolder remotePublisherSDP;
    private SDPHolder remoteSubscriberSDP;
    private Map<String, Content.Creator> publisherContentCreators = new ConcurrentHashMap<String, Content.Creator>();
    private Map<String, Content.Creator> subscriberContentCreators = new ConcurrentHashMap<String, Content.Creator>();
    private Listener listener;
    private final DelayedRunQueue cachedLocalPublisherCandidatesQueue = new DelayedRunQueue();
    private final DelayedRunQueue cachedLocalSubscriberCandidatesQueue = new DelayedRunQueue();
    private final CopyOnWriteArrayList<Publisher> publishers = new CopyOnWriteArrayList();

    public Participation(Meet meet, JID jid, LocalPublisher localPublisher, LocalSubscriber localSubscriber) {
        super(meet, jid, localPublisher, localSubscriber);
    }

    @Override
    public void addedPublishers(Collection<Publisher> publishers) {
        this.publishers.addAll(publishers);
        this.listener.publishersJoined(publishers);
        super.addedPublishers(publishers);
    }

    @Override
    public void removedPublishers(long publisherId) {
        this.publishers.stream().filter(publisher -> publisher.getId() == publisherId).findFirst().ifPresent(publisher -> {
            this.listener.publishersLeft(Collections.singletonList(publisher));
            this.publishers.remove(publisher);
        });
        super.removedPublishers(publisherId);
    }

    @Override
    public synchronized void terminateSubscriberSession() {
        this.getSubscriberSessionId().ifPresent(sessionId -> this.listener.terminatedSubscriberSession((String)sessionId));
        super.terminateSubscriberSession();
    }

    @Override
    public synchronized void terminatePublisherSession() {
        this.getPublisherSessionId().ifPresent(sessionId -> this.listener.terminatedPublisherSession((String)sessionId));
        super.terminatePublisherSession();
    }

    public CompletableFuture<SDP> sendPublisherSDP(String sessionId, ContentAction action, SDP sdpOffer) {
        SDP prevSDP;
        if (this.getPublisherSessionId().filter(sessionId::equals).isEmpty()) {
            return CompletableFuture.failedFuture(new ComponentException(Authorization.CONFLICT));
        }
        this.updatePublisherContentCreators(sdpOffer);
        SDP sDP = prevSDP = this.remotePublisherSDP == null ? null : this.remotePublisherSDP.sdp();
        if (prevSDP == null) {
            JSEP jsepOffer = new JSEP(JSEP.Type.offer, sdpOffer.toString("0", Content.Creator.responder, SDP.Direction.incoming));
            this.remotePublisherSDP = new SDPHolder(sdpOffer, jsepOffer);
            return ((CompletableFuture)((CompletableFuture)this.sendPublisherSDP(jsepOffer).thenApply(jsepAnswer -> new SDPHolder(SDP.from(jsepAnswer.getSdp(), this::getPublisherContentCreatorFor, Content.Creator.responder), (JSEP)jsepAnswer))).whenComplete((sdpHolder, ex) -> {
                Participation participation = this;
                synchronized (participation) {
                    this.updatePublisherContentCreators(sdpHolder.sdp());
                    this.localPublisherSDP = sdpHolder;
                    this.cachedLocalPublisherCandidatesQueue.delayFinished();
                }
            })).thenApply(SDPHolder::sdp);
        }
        JSEP jsepOffer = new JSEP(JSEP.Type.offer, prevSDP.applyDiff(action, sdpOffer).toString("0", Content.Creator.responder, SDP.Direction.incoming));
        this.remotePublisherSDP = new SDPHolder(sdpOffer, jsepOffer);
        return ((CompletableFuture)((CompletableFuture)this.sendPublisherSDP(jsepOffer).thenApply(jsepAnswer -> new SDPHolder(SDP.from(jsepAnswer.getSdp(), this::getPublisherContentCreatorFor, Content.Creator.responder), (JSEP)jsepAnswer))).whenComplete((sdpHolder, ex) -> {
            Participation participation = this;
            synchronized (participation) {
                this.updatePublisherContentCreators(sdpHolder.sdp());
                this.localPublisherSDP = sdpHolder;
                this.cachedLocalPublisherCandidatesQueue.delayFinished();
            }
        })).thenApply(SDPHolder::sdp);
    }

    @Override
    protected synchronized void receivedPublisherSDP(String sessionId, JSEP jsep) {
        SDP prevSDP = this.localPublisherSDP == null ? null : this.localPublisherSDP.sdp();
        SDP currentSDP = SDP.from(jsep.getSdp(), this::getPublisherContentCreatorFor, Content.Creator.responder);
        this.updatePublisherContentCreators(currentSDP);
        this.localPublisherSDP = new SDPHolder(currentSDP, jsep);
        if (prevSDP == null) {
            this.listener.receivedPublisherSDP(sessionId, ContentAction.init, currentSDP);
            this.cachedLocalPublisherCandidatesQueue.delayFinished();
        } else {
            Map<ContentAction, SDP> results = currentSDP.diffFrom(prevSDP);
            for (ContentAction action : ContentAction.values()) {
                SDP sdp = results.get((Object)action);
                if (sdp == null) continue;
                this.listener.receivedPublisherSDP(sessionId, action, sdp);
            }
        }
    }

    @Override
    protected synchronized void receivedPublisherCandidate(String sessionId, JanusPlugin.Candidate candidate) {
        this.cachedLocalPublisherCandidatesQueue.offer(() -> {
            Content content = this.convertCandidateToContent(Content.Creator.initiator, this.localPublisherSDP.sdp(), candidate);
            if (content != null) {
                this.listener.receivedPublisherCandidate(sessionId, content);
            } else {
                log.log(Level.WARNING, () -> "ERROR: it was not possible to convert publisher JanusPlugin.Candidate to Candidate, " + candidate);
            }
        });
    }

    public CompletableFuture<Void> sendSubscriberSDP(String sessionId, ContentAction action, SDP sdpAnswer) {
        SDP prevSDP;
        if (this.getSubscriberSessionId().filter(sessionId::equals).isEmpty()) {
            return CompletableFuture.failedFuture(new ComponentException(Authorization.CONFLICT));
        }
        this.updateSubscriberContentCreators(sdpAnswer);
        SDP sDP = prevSDP = this.remoteSubscriberSDP == null ? null : this.remoteSubscriberSDP.sdp();
        if (prevSDP == null) {
            JSEP jsepOffer = new JSEP(JSEP.Type.answer, sdpAnswer.toString("0", Content.Creator.initiator, SDP.Direction.incoming));
            this.remoteSubscriberSDP = new SDPHolder(sdpAnswer, jsepOffer);
            return this.sendSubscriberSDP(jsepOffer);
        }
        JSEP jsepOffer = new JSEP(JSEP.Type.answer, prevSDP.applyDiff(action, sdpAnswer).toString("0", Content.Creator.initiator, SDP.Direction.incoming));
        this.remoteSubscriberSDP = new SDPHolder(sdpAnswer, jsepOffer);
        return this.sendSubscriberSDP(jsepOffer);
    }

    @Override
    protected void receivedSubscriberSDP(String sessionId, JSEP jsep) {
        SDP prevSDP = this.localSubscriberSDP == null ? null : this.localSubscriberSDP.sdp();
        SDP currentSDP = SDP.from(jsep.getSdp(), this::getSubscriberContentCreatorFor, Content.Creator.initiator);
        this.updateSubscriberContentCreators(currentSDP);
        this.localSubscriberSDP = new SDPHolder(currentSDP, jsep);
        if (prevSDP == null) {
            this.listener.receivedSubscriberSDP(sessionId, ContentAction.init, currentSDP);
            this.cachedLocalSubscriberCandidatesQueue.delayFinished();
        } else {
            Map<ContentAction, SDP> results = currentSDP.diffFrom(prevSDP);
            for (ContentAction action : ContentAction.values()) {
                SDP sdp = results.get((Object)action);
                if (sdp == null) continue;
                this.listener.receivedSubscriberSDP(sessionId, action, sdp);
                if (action != ContentAction.modify) continue;
                this.sendSubscriberSDP(this.remoteSubscriberSDP.jsep);
            }
        }
    }

    @Override
    protected void receivedSubscriberCandidate(String sessionId, JanusPlugin.Candidate candidate) {
        this.cachedLocalSubscriberCandidatesQueue.offer(() -> {
            Content content = this.convertCandidateToContent(Content.Creator.initiator, this.localSubscriberSDP.sdp(), candidate);
            if (content != null) {
                this.listener.receivedSubscriberCandidate(sessionId, content);
            } else {
                log.log(Level.WARNING, "ERROR: it was not possible to convert subscriber JanusPlugin.Candidate to Candidate, " + candidate);
            }
        });
    }

    public void sendCandidate(String sessionId, String contentName, Candidate candidate) {
        if (this.getPublisherSessionId().filter(sessionId::equals).isPresent()) {
            this.sendPublisherCandidate(contentName, candidate);
            return;
        }
        if (this.getSubscriberSessionId().filter(sessionId::equals).isPresent()) {
            this.sendSubscriberCandidate(contentName, candidate);
            return;
        }
    }

    public void sendPublisherCandidate(String contentName, Candidate candidate) {
        this.sendPublisherCandidate(new JanusPlugin.Candidate(contentName, this.findSdpMLineIndex(this.remotePublisherSDP.jsep(), contentName), candidate.toSDP()));
    }

    public void sendSubscriberCandidate(String contentName, Candidate candidate) {
        this.sendSubscriberCandidate(new JanusPlugin.Candidate(contentName, this.findSdpMLineIndex(this.remoteSubscriberSDP.jsep(), contentName), candidate.toSDP()));
    }

    public CompletableFuture<Void> updateSDP(String sessionId, ContentAction action, SDP sdp) {
        if (this.getPublisherSessionId().filter(sessionId::equals).isPresent()) {
            return this.sendPublisherSDP(sessionId, action, sdp).thenApply(x -> null);
        }
        if (this.getSubscriberSessionId().filter(sessionId::equals).isPresent()) {
            return this.sendSubscriberSDP(sessionId, action, sdp);
        }
        return CompletableFuture.failedFuture(new ComponentException(Authorization.ITEM_NOT_FOUND));
    }

    protected int findSdpMLineIndex(JSEP jsep, String contentName) {
        String[] lines = jsep.getSdp().split("\r\n");
        List contents = Arrays.stream(lines).filter(it -> it.startsWith("a=mid:")).collect(Collectors.toList());
        int idx = contents.indexOf("a=mid:" + contentName);
        if (idx == -1) {
            log.log(Level.WARNING, "content '" + contentName + "' was not found in " + ((Meet)this.getMeet()).getJid() + " SDP sent to " + this.getJid());
            idx = 0;
        }
        return idx;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
        this.setListeners();
    }

    protected Content convertCandidateToContent(Content.Creator role, SDP sdp, JanusPlugin.Candidate janusCandidate) {
        if (sdp == null) {
            return null;
        }
        Candidate candidate = Candidate.from(janusCandidate.getCandidate());
        if (candidate == null) {
            return null;
        }
        String mid = Optional.ofNullable(janusCandidate.getMid()).or(() -> sdp.getContents().stream().map(Content::getName).findFirst()).get();
        Optional transport = sdp.getContents().stream().filter(c -> mid.equals(c.getName())).findFirst().flatMap(it -> it.getTransports().stream().findFirst());
        if (transport.isEmpty()) {
            return null;
        }
        return new Content(role, mid, Optional.empty(), Optional.empty(), List.of(new Transport(((Transport)transport.get()).getUfrag(), ((Transport)transport.get()).getPwd(), List.of(candidate), Optional.empty())));
    }

    protected Content.Creator getPublisherContentCreatorFor(String name) {
        return Optional.ofNullable(this.publisherContentCreators.get(name)).orElse(Content.Creator.responder);
    }

    protected void updatePublisherContentCreators(SDP sdp) {
        for (Content content : sdp.getContents()) {
            this.publisherContentCreators.put(content.getName(), content.getCreator());
        }
    }

    protected Content.Creator getSubscriberContentCreatorFor(String name) {
        return Optional.ofNullable(this.subscriberContentCreators.get(name)).orElse(Content.Creator.initiator);
    }

    protected void updateSubscriberContentCreators(SDP sdp) {
        for (Content content : sdp.getContents()) {
            this.subscriberContentCreators.put(content.getName(), content.getCreator());
        }
    }

    public static interface Listener {
        public void publishersJoined(Collection<Publisher> var1);

        public void publishersLeft(Collection<Publisher> var1);

        public void receivedPublisherSDP(String var1, ContentAction var2, SDP var3);

        public void receivedPublisherCandidate(String var1, Content var2);

        public void terminatedPublisherSession(String var1);

        public void receivedSubscriberSDP(String var1, ContentAction var2, SDP var3);

        public void receivedSubscriberCandidate(String var1, Content var2);

        public void terminatedSubscriberSession(String var1);
    }

    public record SDPHolder(SDP sdp, JSEP jsep) {
    }
}

