/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.ComponentException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.meet.IMeetRepository;
import tigase.meet.Meet;
import tigase.meet.MeetComponent;
import tigase.meet.PresenceCollectorRepository;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.JanusService;
import tigase.meet.janus.videoroom.JanusVideoRoomPlugin;
import tigase.server.AbstractMessageReceiver;
import tigase.stats.StatisticsList;
import tigase.util.common.TimerTask;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="meetRepository", parent=MeetComponent.class, active=true)
public class MeetRepository
implements IMeetRepository {
    private static final Logger log = Logger.getLogger(MeetRepository.class.getCanonicalName());
    private final ConcurrentHashMap<BareJID, CompletableFuture<Meet>> meets = new ConcurrentHashMap();
    @ConfigField(desc="Bean name")
    private String name;
    @Inject(bean="service")
    private AbstractMessageReceiver component;
    @Inject
    private JanusService janusService;
    @Inject(nullAllowed=true)
    private PresenceCollectorRepository presenceCollectorRepository;
    private final CounterWithSupplier meetsCounter = new CounterWithSupplier("active meetings", Level.FINEST, () -> this.size());

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public CompletableFuture<Meet> create(BareJID key, int maxNoOfPublishers) {
        CompletableFuture<Meet> future = new CompletableFuture<Meet>();
        if (this.meets.putIfAbsent(key, future) != null) {
            future.completeExceptionally(new ComponentException(Authorization.CONFLICT));
            return future;
        }
        this.createMeet(key, maxNoOfPublishers).whenComplete((meet, ex) -> {
            if (ex != null) {
                this.meets.remove(key, future);
                future.completeExceptionally((Throwable)ex);
            } else {
                if (this.presenceCollectorRepository != null) {
                    this.presenceCollectorRepository.meetCreated(meet.getJid());
                }
                future.complete((Meet)meet);
            }
        });
        return future;
    }

    @Override
    public Meet getMeet(BareJID jid) throws ComponentException {
        CompletableFuture<Meet> future = this.meets.get(jid);
        if (future != null && future.isDone() && !future.isCompletedExceptionally()) {
            try {
                return future.get();
            }
            catch (Throwable ex) {
                throw new ComponentException(Authorization.INTERNAL_SERVER_ERROR, ex.getMessage(), ex);
            }
        }
        throw new ComponentException(Authorization.ITEM_NOT_FOUND);
    }

    @Override
    public void destroyed(BareJID jid) {
        this.meets.remove(jid);
        if (this.presenceCollectorRepository != null) {
            this.presenceCollectorRepository.meetDestroyed(jid);
        }
        log.log(Level.FINEST, () -> "meet " + jid + " was destroyed");
    }

    @Override
    public int size() {
        return this.meets.size();
    }

    public void everyHour() {
        this.meetsCounter.everyHour();
    }

    public void everyMinute() {
        this.meetsCounter.everyMinute();
    }

    public void everySecond() {
        this.meetsCounter.everySecond();
    }

    @Override
    public int getMaxParticipantsInMeeting() {
        return this.meets.values().stream().filter(future -> future.isDone() && !future.isCancelled() && !future.isCompletedExceptionally()).mapToInt(future -> {
            try {
                return ((Meet)future.get()).getParticipantsCount();
            }
            catch (Throwable ex) {
                return 0;
            }
        }).max().orElse(0);
    }

    public void getStatistics(String s, StatisticsList statisticsList) {
        this.meetsCounter.getStatistics(this.component.getName() + "/" + this.getName(), statisticsList);
    }

    private CompletableFuture<Meet> createMeet(BareJID meetJid, int maxNoOfPublishers) {
        return this.janusService.newConnection().thenCompose(connection -> ((CompletableFuture)((CompletableFuture)connection.createSession().thenCompose(session -> ((CompletableFuture)session.attachPlugin(JanusVideoRoomPlugin.class).thenCompose(videoRoomPlugin -> videoRoomPlugin.createRoom(null, maxNoOfPublishers))).exceptionallyCompose(ex -> session.destroy().handle((x, ex1) -> CompletableFuture.failedFuture(ex))))).thenApply(roomId -> {
            log.log(Level.FINEST, () -> "meet " + meetJid + " was created");
            return new Meet(this, (JanusConnection)connection, roomId, meetJid);
        })).exceptionallyCompose(ex -> {
            connection.close();
            return CompletableFuture.failedFuture(ex);
        }));
    }

    protected TimerTask scheduleJoinTimeoutTask(final Meet meet) {
        TimerTask timerTask = new TimerTask(){

            public void run() {
                if (!meet.hasParticipants()) {
                    meet.destroy();
                }
            }
        };
        this.component.addTimerTask(timerTask, 300000L);
        return timerTask;
    }

    private class CounterWithSupplier {
        private final Supplier<Long> valueSupplier;
        protected final Level level;
        protected String name;
        private long last_hour_counter = 0L;
        private long last_minute_counter = 0L;
        private long last_second_counter = 0L;
        private long maximum = 0L;

        public CounterWithSupplier(String name, Level level, Supplier<Long> valueSupplier) {
            this.name = name;
            this.level = level;
            this.valueSupplier = valueSupplier;
        }

        public synchronized void everyHour() {
            long counter;
            this.last_hour_counter = counter = this.valueSupplier.get().longValue();
        }

        public synchronized void everyMinute() {
            long counter;
            this.last_minute_counter = counter = this.valueSupplier.get().longValue();
        }

        public synchronized void everySecond() {
            long counter;
            this.last_second_counter = counter = this.valueSupplier.get().longValue();
            this.maximum = Math.max(counter, this.maximum);
        }

        public void getStatistics(String compName, StatisticsList list) {
            if (list.checkLevel(this.level)) {
                list.add(compName, this.name + " total", this.valueSupplier.get().longValue(), this.level);
                list.add(compName, this.name + " last hour", this.last_hour_counter, this.level);
                list.add(compName, this.name + " last minute", this.last_minute_counter, this.level);
                list.add(compName, this.name + " last second", this.last_second_counter, this.level);
                list.add(compName, this.name + " maximum", this.maximum, this.level);
            }
        }
    }
}

