/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.modules;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import tigase.component.exceptions.ComponentException;
import tigase.component.responses.AsyncCallback;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.meet.IMeetLogic;
import tigase.meet.IMeetRepository;
import tigase.meet.IPresenceRepository;
import tigase.meet.Meet;
import tigase.meet.MeetComponent;
import tigase.meet.Participation;
import tigase.meet.janus.videoroom.Publisher;
import tigase.meet.jingle.Action;
import tigase.meet.jingle.Candidate;
import tigase.meet.jingle.Content;
import tigase.meet.jingle.ContentAction;
import tigase.meet.jingle.SDP;
import tigase.meet.modules.AbstractModule;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="jingleMeetModule", parent=MeetComponent.class, active=true)
public class JingleMeetModule
extends AbstractModule {
    private static final Criteria a = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"jingle", (String)"urn:xmpp:jingle:1"));
    private static final String[] b = new String[]{"tigase:meet:0", "tigase:meet:0:media:audio", "tigase:meet:0:media:video", "urn:xmpp:jingle:1", "urn:xmpp:jingle:apps:rtp:1", "urn:xmpp:jingle:apps:rtp:audio", "urn:xmpp:jingle:apps:rtp:video", "urn:xmpp:jingle:transports:ice-udp:1", "urn:xmpp:jingle:apps:dtls:0"};
    @Inject
    private IMeetLogic logic;
    @Inject
    private IMeetRepository meetRepository;
    @Inject
    private IPresenceRepository presenceRepository;

    public String[] getFeatures() {
        return b;
    }

    public Criteria getModuleCriteria() {
        return a;
    }

    @Override
    public CompletableFuture<Packet> processPacket(Packet packet) throws ComponentException, TigaseStringprepException {
        if (StanzaType.set != packet.getType()) {
            throw new ComponentException(Authorization.BAD_REQUEST);
        }
        BareJID bareJID = packet.getStanzaTo().getBareJID();
        JID jID = packet.getStanzaFrom();
        Element element = Optional.ofNullable(packet.getElemChild("jingle", "urn:xmpp:jingle:1")).orElseThrow(() -> new ComponentException(Authorization.BAD_REQUEST, "Missing jingle action value"));
        String string = Optional.ofNullable(element.getAttributeStaticStr("sid")).orElseThrow(() -> new ComponentException(Authorization.BAD_REQUEST, "Missing sid"));
        Action action = Optional.ofNullable(element.getAttributeStaticStr("action")).map(Action::from).orElseThrow(() -> new ComponentException(Authorization.BAD_REQUEST, "Invalid jingle action value"));
        switch (packet.getType()) {
            case set: {
                if (!this.presenceRepository.isAvailable(bareJID, jID)) {
                    throw new ComponentException(Authorization.NOT_ALLOWED, "Meet is not aware of your presence!");
                }
                this.log.log(Level.FINEST, () -> "meet " + bareJID + " from " + jID + " received " + action + ": " + element.toString());
                switch (action) {
                    case sessionInitiate: {
                        SDP sDP = SDP.from(element);
                        return ((CompletableFuture)((CompletableFuture)this.a(bareJID).thenCompose(meet -> this.logic.checkPermissionFuture((Meet)meet, jID, IMeetLogic.Action.join))).thenCompose(meet -> meet.join(jID))).thenCompose(participation -> {
                            participation.setListener(new a(bareJID, (Participation)participation));
                            participation.startPublisherSession(string);
                            this.log.log(Level.FINEST, () -> "sending SDP to Janus: " + sDP.toString("0", Content.Creator.responder, SDP.Direction.incoming));
                            return ((CompletableFuture)participation.sendPublisherSDP(string, ContentAction.init, sDP).thenApply(sDP -> {
                                this.log.log(Level.FINEST, "received publisher SDP in completion handler");
                                return packet.okResult((String)null, 0);
                            })).whenComplete((packet, throwable) -> {
                                if (throwable != null) {
                                    participation.leave((Throwable)throwable);
                                }
                            });
                        });
                    }
                    case sessionAccept: {
                        return this.a(bareJID, jID).thenApply(participation -> {
                            SDP sDP = SDP.from(element);
                            participation.sendSubscriberSDP(string, ContentAction.init, sDP);
                            return packet.okResult((String)null, 0);
                        });
                    }
                    case contentAdd: 
                    case contentModify: 
                    case contentRemove: 
                    case contentAccept: {
                        return this.a(bareJID, jID).thenApply(participation -> {
                            SDP sDP = SDP.from(element);
                            if (sDP != null) {
                                ContentAction contentAction = ContentAction.fromJingleAction(action);
                                participation.updateSDP(string, contentAction, sDP).whenComplete((void_, throwable) -> {
                                    if (throwable != null) {
                                        participation.leave((Throwable)throwable);
                                    }
                                });
                            }
                            return packet.okResult((String)null, 0);
                        });
                    }
                    case transportInfo: {
                        return this.a(bareJID, jID).thenApply(participation -> {
                            for (Content content : Optional.ofNullable(element.getChildren()).orElse(Collections.emptyList()).stream().map(Content::from).filter(Objects::nonNull).collect(Collectors.toList())) {
                                content.getTransports().stream().findFirst().ifPresent(transport -> {
                                    for (Candidate candidate : transport.getCandidates()) {
                                        participation.sendCandidate(string, content.getName(), candidate);
                                    }
                                });
                            }
                            return packet.okResult((String)null, 0);
                        });
                    }
                    case sessionTerminate: {
                        return this.a(bareJID, jID).thenApply(participation -> {
                            participation.leave(null);
                            return packet.okResult((String)null, 0);
                        });
                    }
                }
                throw new ComponentException(Authorization.FEATURE_NOT_IMPLEMENTED);
            }
        }
        throw new IllegalStateException("Unexpected value: " + packet.getType());
    }

    private CompletableFuture<Meet> a(BareJID bareJID) throws ComponentException {
        return CompletableFuture.completedFuture(this.meetRepository.getMeet(bareJID));
    }

    private CompletableFuture<Participation> a(BareJID bareJID, JID jID) throws ComponentException {
        return this.a(bareJID).thenCompose(meet -> {
            Participation participation = meet.getParticipation(jID);
            if (participation == null) {
                this.log.log(Level.FINEST, () -> "user " + jID + " requested participation in " + bareJID + " but there is none");
                return CompletableFuture.failedFuture(new ComponentException(Authorization.ITEM_NOT_FOUND));
            }
            return CompletableFuture.completedFuture(participation);
        });
    }

    private CompletableFuture<Void> a(BareJID bareJID, JID jID, Action action, String string, SDP sDP, Participation participation) {
        return this.a(bareJID, jID, action, string, sDP).whenComplete((void_, throwable) -> {
            if (throwable != null) {
                this.log.log(Level.FINEST, (Throwable)throwable, () -> "meet " + bareJID + " received from " + jID + " an error response on " + action);
                participation.leave((Throwable)throwable);
            }
        });
    }

    private CompletableFuture<Void> a(BareJID bareJID, JID jID, Action action, String string, SDP sDP) {
        Element element = new Element("iq");
        element.setAttribute("id", UUID.randomUUID().toString());
        element.setAttribute("type", StanzaType.set.name());
        element.addChild((XMLNodeIfc)sDP.toElement(action, string, JID.jidInstanceNS((BareJID)bareJID)));
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.writer.write((Packet)new Iq(element, JID.jidInstanceNS((BareJID)bareJID), jID), new AsyncCallback(){

            public void onError(Packet packet, String s) {
                completableFuture.completeExceptionally(new ComponentException(Authorization.getByCondition((String)packet.getErrorCondition())));
            }

            public void onSuccess(Packet packet) {
                completableFuture.complete(null);
            }

            public void onTimeout() {
                completableFuture.completeExceptionally(new ComponentException(Authorization.REMOTE_SERVER_TIMEOUT));
            }
        });
        return completableFuture;
    }

    private void a(BareJID bareJID, JID jID, String string, Collection<Publisher> collection) {
        Element element = new Element("iq");
        element.setAttribute("id", UUID.randomUUID().toString());
        element.setAttribute("type", StanzaType.set.name());
        Element element2 = new Element(string);
        element2.setXMLNS("tigase:meet:0");
        collection.stream().map(publisher -> {
            Element element = new Element("publisher");
            element.setAttribute("jid", publisher.getDisplay());
            publisher.getStreams().stream().map(stream -> new Element("stream", new String[]{"mid"}, new String[]{stream.getMid()})).forEach(arg_0 -> ((Element)element).addChild(arg_0));
            return element;
        }).forEach(arg_0 -> ((Element)element2).addChild(arg_0));
        element.addChild((XMLNodeIfc)element2);
        this.writer.write(Packet.packetInstance((Element)element, (JID)JID.jidInstanceNS((BareJID)bareJID), (JID)jID));
    }

    private class a
    implements Participation.Listener {
        private final BareJID b;
        private final Participation c;

        public a(BareJID bareJID, Participation participation) {
            this.b = bareJID;
            this.c = participation;
        }

        @Override
        public void publishersJoined(Collection<Publisher> publishers) {
            JingleMeetModule.this.a(this.b, this.c.getJid(), "joined", publishers);
        }

        @Override
        public void publishersLeft(Collection<Publisher> publishers) {
            JingleMeetModule.this.a(this.b, this.c.getJid(), "left", publishers);
        }

        @Override
        public void receivedPublisherSDP(String sessionId, ContentAction contentAction, SDP sdp) {
            JingleMeetModule.this.a(this.b, this.c.getJid(), contentAction.toJingleAction(Action.sessionAccept), sessionId, sdp, this.c);
        }

        @Override
        public void receivedPublisherCandidate(String sessionId, Content content) {
            JingleMeetModule.this.a(this.b, this.c.getJid(), Action.transportInfo, sessionId, new SDP("", List.of(content), Collections.emptyList()));
        }

        @Override
        public void terminatedPublisherSession(String sessionId) {
            JingleMeetModule.this.a(this.b, this.c.getJid(), Action.sessionTerminate, sessionId, new SDP("", Collections.emptyList(), Collections.emptyList()));
        }

        @Override
        public void receivedSubscriberSDP(String sessionId, ContentAction contentAction, SDP sdp) {
            JingleMeetModule.this.a(this.b, this.c.getJid(), contentAction.toJingleAction(Action.sessionInitiate), sessionId, sdp, this.c);
        }

        @Override
        public void receivedSubscriberCandidate(String sessionId, Content content) {
            JingleMeetModule.this.a(this.b, this.c.getJid(), Action.transportInfo, sessionId, new SDP("", List.of(content), Collections.emptyList()));
        }

        @Override
        public void terminatedSubscriberSession(String sessionId) {
            JingleMeetModule.this.a(this.b, this.c.getJid(), Action.sessionTerminate, sessionId, new SDP("", Collections.emptyList(), Collections.emptyList()));
        }
    }
}

