/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import tigase.meet.jingle.Candidate;
import tigase.meet.jingle.Fingerprint;
import tigase.xml.Element;

public class Transport {
    private final Optional<String> a;
    private final Optional<String> b;
    private final List<Candidate> c;
    private final Optional<Fingerprint> d;

    public static Transport from(Element el) {
        if ("transport".equals(el.getName())) {
            Optional<String> optional = Optional.ofNullable(el.getAttributeStaticStr("ufrag"));
            Optional<String> optional2 = Optional.ofNullable(el.getAttributeStaticStr("pwd"));
            List list = Optional.ofNullable(el.getChildren()).orElse(Collections.emptyList());
            Optional<Fingerprint> optional3 = list.stream().map(Fingerprint::from).filter(Objects::nonNull).findFirst();
            List<Candidate> list2 = list.stream().map(Candidate::from).filter(Objects::nonNull).collect(Collectors.toList());
            return new Transport(optional, optional2, list2, optional3);
        }
        return null;
    }

    public Transport(Optional<String> ufrag, Optional<String> pwd, List<Candidate> candidates, Optional<Fingerprint> fingerprint) {
        this.a = ufrag;
        this.b = pwd;
        this.c = candidates;
        this.d = fingerprint;
    }

    public Optional<String> getUfrag() {
        return this.a;
    }

    public Optional<String> getPwd() {
        return this.b;
    }

    public List<Candidate> getCandidates() {
        return this.c;
    }

    public Optional<Fingerprint> getFingerprint() {
        return this.d;
    }

    public Element toElement() {
        Element element = new Element("transport");
        element.setXMLNS("urn:xmpp:jingle:transports:ice-udp:1");
        this.d.map(Fingerprint::toElement).ifPresent(arg_0 -> ((Element)element).addChild(arg_0));
        this.c.stream().map(Candidate::toElement).forEach(arg_0 -> ((Element)element).addChild(arg_0));
        this.a.ifPresent(string -> element.setAttribute("ufrag", string));
        this.b.ifPresent(string -> element.setAttribute("pwd", string));
        return element;
    }
}

