/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import tigase.component.DSLBeanConfigurator;
import tigase.conf.ConfigBuilder;
import tigase.kernel.AbstractKernelTestCase;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.kernel.core.Kernel;
import tigase.meet.janus.JSEP;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.JanusService;
import tigase.meet.janus.JanusSession;
import tigase.meet.janus.videoroom.JanusVideoRoomPlugin;
import tigase.meet.janus.videoroom.LocalPublisher;
import tigase.meet.janus.videoroom.LocalSubscriber;
import tigase.util.log.LogFormatter;

@Ignore
public class JanusServiceTest
extends AbstractKernelTestCase {
    private static final String TEST_SDP = "v=0\no=- 7748854561613975422 2 IN IP4 127.0.0.1\ns=-\nt=0 0\na=group:BUNDLE m0\na=msid-semantic: WMS RTCmS\nm=audio 64527 UDP/TLS/RTP/SAVPF 111 103 104 9 102 0 8 106 105 13 110 112 113 126\nc=IN IP4 10.28.28.197\na=rtcp:9 IN IP4 0.0.0.0\na=candidate:3565984846 1 udp 2122260224 10.28.28.197 64527 typ host generation 0 network-id 1 network-cost 50\na=ice-ufrag:AZw+\na=ice-pwd:Gydud5GVcWgjUFRznV/hh2QY\na=ice-options:trickle renomination\na=fingerprint:sha-256 D1:3A:E1:0A:05:D1:74:E7:A4:1F:E3:33:3B:46:17:DD:55:15:F5:A1:D6:42:DA:03:07:3F:26:5B:73:8E:E3:8E\na=setup:actpass\na=mid:m0\na=extmap:1 urn:ietf:params:rtp-hdrext:ssrc-audio-level\na=extmap:9 urn:ietf:params:rtp-hdrext:sdes:mid\na=sendrecv\na=msid:RTCmS audio0\na=rtcp-mux\na=rtpmap:111 opus/48000/2\na=rtcp-fb:111 transport-cc\na=fmtp:111 minptime=10;useinbandfec=1\na=rtpmap:103 ISAC/16000\na=rtpmap:104 ISAC/32000\na=rtpmap:9 G722/8000\na=rtpmap:102 ILBC/8000\na=rtpmap:0 PCMU/8000\na=rtpmap:8 PCMA/8000\na=rtpmap:106 CN/32000\na=rtpmap:105 CN/16000\na=rtpmap:13 CN/8000\na=rtpmap:110 telephone-event/48000\na=rtpmap:112 telephone-event/32000\na=rtpmap:113 telephone-event/16000\na=rtpmap:126 telephone-event/8000\na=ssrc:4276098296 cname:6NCBp2ajBbDLtr7M\na=ssrc:4276098296 msid:RTCmS audio0\na=ssrc:4276098296 mslabel:RTCmS\na=ssrc:4276098296 label:audio0";
    JanusService janusService;

    public static void configureLogging(Level level) {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter((Formatter)new LogFormatter(true));
        handler.setLevel(level);
        Logger logger = Logger.getLogger("tigase.meet");
        logger.addHandler(handler);
        logger.setUseParentHandlers(false);
        logger.setLevel(level);
    }

    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean(DefaultTypesConverter.class).setActive(true).exec();
        kernel.registerBean(DSLBeanConfigurator.class).setActive(true).exec();
        kernel.registerBean(JanusService.class).setActive(true).exec();
    }

    @Before
    public void setupJanus() {
        JanusServiceTest.configureLogging(Level.FINEST);
        ConfigBuilder configBuilder = (ConfigBuilder)new ConfigBuilder().with(new AbstractBeanConfigurator.BeanDefinition[]{((AbstractBeanConfigurator.BeanDefinition.Builder)new AbstractBeanConfigurator.BeanDefinition.Builder().name("janus").active(true).with("uri", (Object)"ws://127.0.0.1:8188/")).build()});
        ((DSLBeanConfigurator)this.getKernel().getInstance(DSLBeanConfigurator.class)).setProperties(configBuilder.build());
        this.janusService = (JanusService)this.getKernel().getInstance(JanusService.class);
    }

    @Test
    public void test() throws ExecutionException, InterruptedException, IOException {
        CompletableFuture future = this.janusService.newConnection();
        JanusConnection connection = (JanusConnection)future.get();
        CompletableFuture result1 = connection.createSession();
        CompletableFuture result2 = connection.getInfo();
        CompletableFuture.allOf(result1, result2).get();
        JanusSession session = (JanusSession)result1.get();
        CompletableFuture pluginFuture = session.attachPlugin(JanusVideoRoomPlugin.class);
        JanusVideoRoomPlugin plugin1 = (JanusVideoRoomPlugin)pluginFuture.get();
        JanusSession session2 = (JanusSession)connection.createSession().get();
        JanusVideoRoomPlugin plugin2 = (JanusVideoRoomPlugin)session2.attachPlugin(JanusVideoRoomPlugin.class).get();
        Long roomId = 1234L;
        try {
            roomId = plugin1.createRoom((Object)1234L, 3).get();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        LocalPublisher localPublisher2 = (LocalPublisher)plugin2.createPublisher((Object)roomId, "Local publisher 1").get();
        LocalPublisher localPublisher1 = (LocalPublisher)plugin1.createPublisher((Object)roomId, "Local publisher 2").get();
        Thread.sleep(400L);
        Assert.assertNotNull(localPublisher1.publish(new JSEP(JSEP.Type.offer, TEST_SDP)).get());
        JanusVideoRoomPlugin plugin3 = (JanusVideoRoomPlugin)session.attachPlugin(JanusVideoRoomPlugin.class).get();
        LocalSubscriber localSubscriber3 = plugin3.createSubscriber((Object)roomId);
        localSubscriber3.subscribe(List.of(new JanusVideoRoomPlugin.Stream(4083653061418717L, null))).get();
        Thread.sleep(100L);
        localPublisher1.leave().get();
        localPublisher2.leave();
        session2.destroy().get();
        plugin1.destroyRoom((Object)roomId).get();
        session.keepAlive().get();
        CompletableFuture destroyFuture = ((JanusSession)result1.get()).destroy();
        CompletableFuture.allOf(destroyFuture).get();
    }
}

