/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.xml.Element;

public class SSRCGroup {
    private final String a;
    private final List<String> b;

    public static SSRCGroup from(Element el) {
        if ("ssrc-group".equals(el.getName()) && "urn:xmpp:jingle:apps:rtp:ssma:0".equals(el.getXMLNS())) {
            String string = el.getAttributeStaticStr("semantics");
            if (string == null) {
                return null;
            }
            List<String> list = Optional.ofNullable(el.mapChildren(element -> "source".equals(element.getName()), element -> element.getAttributeStaticStr("ssrc"))).orElse(Collections.emptyList());
            return new SSRCGroup(string, list);
        }
        return null;
    }

    public static List<SSRCGroup> from(String[] lines) {
        return Arrays.stream(lines).filter(string -> string.startsWith("a=ssrc-group:")).map(string -> string.substring("a=ssrc-group:".length())).map(string -> string.split(" ")).filter(stringArray -> ((String[])stringArray).length >= 2).map(stringArray -> new SSRCGroup(stringArray[0], Arrays.stream(stringArray).skip(1L).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    public SSRCGroup(String semantics, List<String> sources) {
        this.a = semantics;
        this.b = sources;
    }

    public String getSemantics() {
        return this.a;
    }

    public List<String> getSources() {
        return this.b;
    }

    public Element toElement() {
        Element element = new Element("ssrc-group");
        element.setXMLNS("urn:xmpp:jingle:apps:rtp:ssma:0");
        element.setAttribute("semantics", this.a);
        this.b.stream().map(string -> new Element("source", new String[]{"ssrc"}, new String[]{string})).forEach(arg_0 -> ((Element)element).addChild(arg_0));
        return element;
    }

    public String toSDP() {
        return Stream.concat(Stream.of("a=ssrc-group:" + this.a), this.b.stream()).collect(Collectors.joining(" "));
    }
}

