/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.JanusPlugin;

public class JanusSession {
    private static final Logger a = Logger.getLogger(JanusSession.class.getCanonicalName());
    private final JanusConnection b;
    private final long c;
    private ScheduledFuture<?> d;
    private final ConcurrentHashMap<Long, JanusPlugin> e = new ConcurrentHashMap();

    protected JanusSession(JanusConnection connection, Map<String, Object> sessionData) {
        if (sessionData == null) {
            throw new IllegalArgumentException("Missing 'sessionData'!");
        }
        Long l = (Long)sessionData.get("id");
        if (l == null) {
            throw new IllegalArgumentException("Missing session id!");
        }
        this.b = connection;
        this.c = l;
    }

    public JanusConnection getConnection() {
        return this.b;
    }

    public long getSessionId() {
        return this.c;
    }

    public String nextTransactionId() {
        return this.b.nextTransactionId();
    }

    public String logPrefix() {
        return this.b.logPrefix() + ", session " + this.getSessionId();
    }

    public String logPrefix(String transaction) {
        return this.b.logPrefix(transaction) + ", session " + this.getSessionId();
    }

    public void handleEvent(Map<String, Object> event) {
        Long l = (Long)event.get("sender");
        if (l != null) {
            JanusPlugin janusPlugin = this.e.get(l);
            if (janusPlugin != null) {
                Object t = janusPlugin.extractData(event);
                janusPlugin.handleEvent(t);
            } else {
                a.log(Level.WARNING, () -> this.logPrefix() + ", received event from unknown sender: " + l + ", values: " + event);
            }
        } else {
            a.log(Level.WARNING, () -> this.logPrefix() + ", received event from without sender, values: " + event);
        }
    }

    public void handleTrickle(Map<String, Object> trickle) {
        Long l = (Long)trickle.get("sender");
        if (l != null) {
            JanusPlugin janusPlugin = this.e.get(l);
            if (janusPlugin != null) {
                janusPlugin.handleTrickle(trickle);
            } else {
                a.log(Level.WARNING, () -> this.logPrefix() + ", received trickle from unknown sender: " + l + ", values: " + trickle);
            }
        } else {
            a.log(Level.WARNING, () -> this.logPrefix() + ", received trickle from without sender, values: " + trickle);
        }
    }

    public CompletableFuture<Map<String, Object>> execute(String janus, String transaction, JanusConnection.RequestGenerator requestGenerator) {
        return this.b.execute(janus, transaction, jsonGenerator -> {
            jsonGenerator.writeNumberField("session_id", this.c);
            requestGenerator.accept(jsonGenerator);
        });
    }

    public CompletableFuture<Void> send(String janus, String transaction, JanusConnection.RequestGenerator requestGenerator) {
        return this.b.send(janus, transaction, jsonGenerator -> {
            jsonGenerator.writeNumberField("session_id", this.c);
            requestGenerator.accept(jsonGenerator);
        });
    }

    public <T extends JanusPlugin> CompletableFuture<T> attachPlugin(Class<T> pluginClass) {
        String string = this.nextTransactionId();
        String string2 = this.b.getPluginId(pluginClass);
        a.log(Level.FINER, () -> this.logPrefix(string) + ", attaching plugin " + string2 + " with class " + pluginClass.getCanonicalName() + "...");
        return ((CompletableFuture)this.execute("attach", string, jsonGenerator -> jsonGenerator.writeStringField("plugin", string2)).thenApply(map -> JanusPlugin.newInstance(pluginClass, this, (Map)map.get("data")))).whenComplete((janusPlugin, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.logPrefix(string) + ", plugin " + string2 + " with class " + pluginClass.getCanonicalName() + " attachment failed.");
            } else {
                a.log(Level.FINER, () -> this.logPrefix(string) + ", plugin " + janusPlugin + " attached.");
                this.e.put(janusPlugin.getHandleId(), (JanusPlugin)janusPlugin);
            }
        });
    }

    public CompletableFuture<Void> detachPlugin(JanusPlugin plugin) {
        String string = this.nextTransactionId();
        a.log(Level.FINER, () -> this.logPrefix(string) + ", detaching plugin " + plugin + "...");
        return ((CompletableFuture)this.execute("detach", string, jsonGenerator -> jsonGenerator.writeNumberField("handle_id", plugin.getHandleId())).whenComplete((map, throwable) -> {
            if (throwable != null) {
                a.log(Level.WARNING, (Throwable)throwable, () -> this.logPrefix(string) + ", plugin " + plugin + " detachment failed.");
            } else {
                a.log(Level.FINER, () -> this.logPrefix(string) + ", plugin " + plugin.toString() + " detached.");
                if (this.d != null) {
                    this.d.cancel(false);
                }
                this.e.remove(plugin.getHandleId());
            }
        })).thenApply(map -> null);
    }

    public CompletableFuture<Void> keepAlive() {
        return this.send("keepalive", this.nextTransactionId(), jsonGenerator -> {});
    }

    public void scheduleKeepAlive(ScheduledExecutorService executorService, Duration sessionTimeout) {
        if (this.d != null) {
            this.d.cancel(false);
        }
        long l = sessionTimeout.minusSeconds(5L).toMillis();
        this.d = executorService.scheduleAtFixedRate(this::keepAlive, l, l, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<Void> destroy() {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        CompletableFuture.allOf((CompletableFuture[])this.e.values().stream().map(janusPlugin -> this.detachPlugin((JanusPlugin)janusPlugin)).toArray(CompletableFuture[]::new)).whenComplete((void_2, throwable2) -> {
            if (throwable2 != null) {
                completableFuture.completeExceptionally((Throwable)throwable2);
            } else {
                this.b.destroySession(this).whenComplete((void_, throwable) -> {
                    if (throwable != null) {
                        completableFuture.completeExceptionally((Throwable)throwable);
                    } else {
                        completableFuture.complete(null);
                    }
                });
            }
        });
        return completableFuture;
    }
}

