/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.UUID;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import tigase.meet.jingle.Content;
import tigase.meet.jingle.Description;
import tigase.meet.jingle.Payload;
import tigase.meet.jingle.SDP;

public class SDPTest {
    public static final String TEST_STRING = "v=0\no=- 1623251477217656 2 IN IP4 0.0.0.0\ns=VideoRoom 1234\nt=0 0\na=group:BUNDLE 0 1 2 3\na=ice-options:trickle\na=fingerprint:sha-256 89:5D:8D:AA:1D:0B:6F:7F:54:16:D2:61:E7:B7:4C:D7:0E:DF:93:FD:10:34:66:7A:71:24:0D:D8:45:E9:4C:C9\na=msid-semantic: WMS janus\nm=audio 9 UDP/TLS/RTP/SAVPF 111\nc=IN IP4 0.0.0.0\na=sendonly\na=mid:0\na=rtcp-mux\na=ice-ufrag:HTzj\na=ice-pwd:kLUcEX+Rrq4lWvUcJA1hZ/\na=ice-options:trickle\na=setup:actpass\na=rtpmap:111 opus/48000/2\na=extmap:1 urn:ietf:params:rtp-hdrext:ssrc-audio-level\na=extmap:4 urn:ietf:params:rtp-hdrext:sdes:mid\na=msid:janus janus0\na=ssrc:4040912716 cname:janus\nm=video 9 UDP/TLS/RTP/SAVPF 96\nc=IN IP4 0.0.0.0\na=sendonly\na=mid:1\na=rtcp-mux\na=ice-ufrag:HTzj\na=ice-pwd:kLUcEX+Rrq4lWvUcJA1hZ/\na=ice-options:trickle\na=setup:actpass\na=rtpmap:96 VP8/90000\na=rtcp-fb:96 ccm fir\na=rtcp-fb:96 nack\na=rtcp-fb:96 nack pli\na=rtcp-fb:96 goog-remb\na=extmap:3 http://www.ietf.org/id/draft-holmer-rmcat-transport-wide-cc-extensions-01\na=extmap:4 urn:ietf:params:rtp-hdrext:sdes:mid\na=extmap:12 http://www.webrtc.org/experiments/rtp-hdrext/playout-delay\na=msid:janus janus1\na=ssrc:740108580 cname:janus\nm=audio 9 UDP/TLS/RTP/SAVPF 111\nc=IN IP4 0.0.0.0\na=sendonly\na=mid:2\na=rtcp-mux\na=ice-ufrag:HTzj\na=ice-pwd:kLUcEX+Rrq4lWvUcJA1hZ/\na=ice-options:trickle\na=setup:actpass\na=rtpmap:111 opus/48000/2\na=extmap:1 urn:ietf:params:rtp-hdrext:ssrc-audio-level\na=extmap:4 urn:ietf:params:rtp-hdrext:sdes:mid\na=msid:janus janus2\na=ssrc:3154195879 cname:janus\nm=video 9 UDP/TLS/RTP/SAVPF 96\nc=IN IP4 0.0.0.0\na=sendonly\na=mid:3\na=rtcp-mux\na=ice-ufrag:HTzj\na=ice-pwd:kLUcEX+Rrq4lWvUcJA1hZ/\na=ice-options:trickle\na=setup:actpass\na=rtpmap:96 VP8/90000\na=rtcp-fb:96 ccm fir\na=rtcp-fb:96 nack\na=rtcp-fb:96 nack pli\na=rtcp-fb:96 goog-remb\na=extmap:3 http://www.ietf.org/id/draft-holmer-rmcat-transport-wide-cc-extensions-01\na=extmap:4 urn:ietf:params:rtp-hdrext:sdes:mid\na=extmap:12 http://www.webrtc.org/experiments/rtp-hdrext/playout-delay\na=msid:janus janus3\na=ssrc:3023058024 cname:janus".replaceAll("\n", "\r\n");

    @Test
    public void testConversion() {
        Function<String, Content.Creator> creatorProvider = name -> Content.Creator.initiator;
        String sid = UUID.randomUUID().toString();
        SDP sdp1 = SDP.from((String)TEST_STRING, creatorProvider, (Content.Creator)Content.Creator.initiator);
        Assert.assertNotNull((Object)sdp1);
        Assert.assertFalse((boolean)sdp1.getBundle().isEmpty());
        Assert.assertFalse((boolean)((Payload)((Description)((Content)sdp1.getContents().get(1)).getDescription().get()).getPayloads().get(0)).getRtcpFeedback().isEmpty());
        String sdpStr1 = sdp1.toString(sid, Content.Creator.initiator, SDP.Direction.outgoing);
        SDP sdp2 = SDP.from((String)sdpStr1, creatorProvider, (Content.Creator)Content.Creator.initiator);
        Assert.assertNotNull((Object)sdp2);
        String sdpStr2 = sdp2.toString(sid, Content.Creator.initiator, SDP.Direction.outgoing);
        Assert.assertEquals((Object)sdp2.getContents(), (Object)sdp2.getContents());
        Assert.assertFalse((boolean)sdp2.getBundle().isEmpty());
        Assert.assertFalse((boolean)((Payload)((Description)((Content)sdp2.getContents().get(1)).getDescription().get()).getPayloads().get(0)).getRtcpFeedback().isEmpty());
        Assert.assertEquals((Object)sdpStr2, (Object)sdpStr1);
    }

    @Test
    public void testConversion2() {
        Function<String, Content.Creator> creatorProvider = name -> Content.Creator.initiator;
        String sid = UUID.randomUUID().toString();
        SDP sdp1 = SDP.from((String)TEST_STRING, creatorProvider, (Content.Creator)Content.Creator.initiator);
        Assert.assertNotNull((Object)sdp1);
        Assert.assertFalse((boolean)sdp1.getBundle().isEmpty());
        Assert.assertFalse((boolean)((Payload)((Description)((Content)sdp1.getContents().get(1)).getDescription().get()).getPayloads().get(0)).getRtcpFeedback().isEmpty());
        String sdpStr1 = sdp1.toString(sid, Content.Creator.initiator, SDP.Direction.outgoing);
        SDP sdp2 = SDP.from((String)sdpStr1, creatorProvider, (Content.Creator)Content.Creator.initiator);
        Assert.assertNotNull((Object)sdp2);
        String sdpStr2 = sdp2.toString(sid, Content.Creator.responder, SDP.Direction.incoming);
        Assert.assertEquals((Object)sdp2.getContents(), (Object)sdp2.getContents());
        Assert.assertFalse((boolean)sdp2.getBundle().isEmpty());
        Assert.assertFalse((boolean)((Payload)((Description)((Content)sdp2.getContents().get(1)).getDescription().get()).getPayloads().get(0)).getRtcpFeedback().isEmpty());
        Assert.assertEquals((Object)sdpStr2, (Object)sdpStr1);
    }
}

