/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup.pages;

import gg.jte.TemplateOutput;
import gg.jte.output.StringOutput;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import tigase.http.api.HttpException;
import tigase.http.api.NotFoundException;
import tigase.http.modules.setup.NextPage;
import tigase.http.modules.setup.SetupModule;
import tigase.http.modules.setup.pages.AbstractPage;
import tigase.http.modules.setup.pages.BasicConfigPage;
import tigase.kernel.beans.Bean;

@Path(value="/license")
@Bean(name="licensePage", parent=SetupModule.class, active=true)
@NextPage(value=BasicConfigPage.class)
public class LicensePage
extends AbstractPage {
    @Override
    public String getTitle() {
        return "License";
    }

    @GET
    public Response displayLicenseInfo() {
        StringOutput output = new StringOutput();
        this.engine.render("license.jte", this.prepareContext(), (TemplateOutput)output);
        return Response.ok((Object)output.toString(), (String)"text/html").build();
    }

    @GET
    @Path(value="/agpl.html")
    public Response displayAGPL() throws HttpException, IOException {
        File licenceFile = new File("License.html");
        if (!licenceFile.exists()) {
            throw new NotFoundException("File is missing");
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream fis = new FileInputStream(licenceFile);){
            return Response.ok((Object)fis.readAllBytes(), (String)"text/html").build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @POST
    public Response processForm(HttpServletRequest request, @FormParam(value="companyName") String companyName) {
        if (this.getConfig().installationContainsACS()) {
            Optional<String> value = Optional.ofNullable(companyName).map(String::trim).filter(str -> !str.isEmpty());
            if (value.isPresent()) {
                this.getConfig().setCompanyName(value.get());
            } else {
                return Response.seeOther((URI)URI.create(request.getRequestURI())).build();
            }
        }
        return this.redirectToNext(request);
    }
}

