/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup.pages;

import gg.jte.TemplateOutput;
import gg.jte.output.StringOutput;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import tigase.db.util.SchemaLoader;
import tigase.http.modules.setup.NextPage;
import tigase.http.modules.setup.SetupModule;
import tigase.http.modules.setup.pages.AbstractPage;
import tigase.http.modules.setup.pages.ConnectivityPage;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.xmpp.jid.BareJID;

@Path(value="/basic")
@NextPage(value=ConnectivityPage.class)
@Bean(name="basicConfigPage", parent=SetupModule.class, active=true)
public class BasicConfigPage
extends AbstractPage {
    @Override
    public String getTitle() {
        return "Basic Tigase server configuration";
    }

    @GET
    public Response getForm() {
        StringOutput output = new StringOutput();
        this.engine.render("basicConfig.jte", this.prepareContext(), (TemplateOutput)output);
        return Response.ok((Object)output.toString(), (String)"text/html").build();
    }

    @POST
    public Response processForm(HttpServletRequest request, @FormParam(value="configType") ConfigTypeEnum configType, @FormParam(value="virtualDomain") String vhost, @FormParam(value="admins") String admins, @FormParam(value="adminPwd") String adminPwd, @FormParam(value="dbType") String dbTypeStr) {
        this.getConfig().setConfigType(Optional.ofNullable(configType).orElse(ConfigTypeEnum.DefaultMode));
        this.getConfig().setDefaultVirtualDomain(vhost);
        this.getConfig().setAdmins(Optional.ofNullable(admins).map(str -> str.split(",")).stream().flatMap(Arrays::stream).map(BareJID::bareJIDInstanceNS).filter(Objects::nonNull).collect(Collectors.toSet()));
        this.getConfig().setAdminPwd(adminPwd);
        SchemaLoader.getAllSupportedTypesStream().filter(type -> type.getName().equals(dbTypeStr)).findFirst().ifPresent(type -> this.getConfig().setDbType((SchemaLoader.TypeInfo)type));
        return this.redirectToNext(request);
    }

    public List<ConfigTypeEnum> getConfigTypes() {
        return List.of(ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode);
    }

    public String getConfigTypeEnumLabel(ConfigTypeEnum value) {
        return switch (value) {
            case ConfigTypeEnum.DefaultMode -> "Default installation";
            case ConfigTypeEnum.SessionManagerMode -> "Session Manager only";
            case ConfigTypeEnum.ConnectionManagersMode -> "Network connectivity only";
            case ConfigTypeEnum.ComponentMode -> "External component only";
            default -> "";
        };
    }
}

