/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import tigase.auth.credentials.entries.XTokenCredentialsEntry;
import tigase.db.AuthRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.Model;
import tigase.http.jaxrs.Page;
import tigase.http.jaxrs.Pageable;
import tigase.http.modules.dashboard.DashboardHandler;
import tigase.http.modules.dashboard.DashboardModule;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.util.Base64;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostManager;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="users", parent=DashboardModule.class, active=true)
@Path(value="/users")
public class UsersHandler
extends DashboardHandler {
    private final SecureRandom secureRandom = new SecureRandom();
    @Inject
    private AuthRepository authRepository;
    @Inject
    private UserRepository userRepository;
    @Inject
    private VHostManager vHostManager;

    @Override
    public Handler.Role getRequiredRole() {
        return Handler.Role.Admin;
    }

    @GET
    @Path(value="")
    @Produces(value={"text/html"})
    public Response index(@QueryParam(value="query") String query, Pageable pageable, Model model) throws TigaseDBException {
        List<String> domains = this.vHostManager.getAllVHosts().stream().map(JID::getDomain).filter(domain -> !"default".equals(domain)).sorted().toList();
        HashSet<String> domainsSet = new HashSet<String>(domains);
        List<BareJID> jids = this.userRepository.getUsers().stream().filter(jid -> jid.getLocalpart() != null).filter(jid -> domainsSet.contains(jid.getDomain())).filter(jid -> query == null || jid.toString().contains(query)).sorted(Comparator.comparing(BareJID::getLocalpart).thenComparing(BareJID::getDomain)).toList();
        List<User> users = jids.stream().skip(pageable.offset()).limit(pageable.pageSize()).map(jid -> {
            try {
                return new User((BareJID)jid, this.authRepository.getAccountStatus(jid));
            }
            catch (TigaseDBException e) {
                throw new RuntimeException(e);
            }
        }).toList();
        model.put("query", query);
        model.put("users", new Page<User>(pageable, jids.size(), users));
        model.put("domains", domains);
        model.put("isXTokenActive", this.authRepository.isMechanismSupported("default", "XTOKEN-HMAC-SHA-256"));
        String output = this.renderTemplate("users/index.jte", model);
        return Response.ok((Object)output, (String)"text/html").build();
    }

    @POST
    @Path(value="/create")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createUser(@FormParam(value="localpart") @NotEmpty String localpart, @FormParam(value="domain") @NotEmpty String domain, @FormParam(value="password") String password, UriInfo uriInfo) throws TigaseStringprepException, TigaseDBException {
        if (localpart.isBlank() || domain.isBlank()) {
            throw new RuntimeException();
        }
        BareJID jid = BareJID.bareJIDInstance((String)localpart, (String)domain);
        if (this.userRepository.userExists(jid)) {
            throw new RuntimeException("User already exist!");
        }
        if (password != null) {
            this.authRepository.addUser(jid, password);
            this.authRepository.setAccountStatus(jid, AuthRepository.AccountStatus.active);
        } else {
            this.userRepository.addUser(jid);
        }
        return UsersHandler.redirectToIndex(uriInfo, jid.toString());
    }

    @POST
    @Path(value="/{jid}/delete")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response deleteUser(@PathParam(value="jid") @NotEmpty BareJID jid, UriInfo uriInfo) throws TigaseDBException {
        this.authRepository.removeUser(jid);
        return UsersHandler.redirectToIndex(uriInfo);
    }

    @GET
    @Path(value="/{jid}/accountStatus/{accountStatus}")
    public Response changeAccountStatus(@PathParam(value="jid") @NotEmpty BareJID jid, @PathParam(value="accountStatus") AuthRepository.AccountStatus accountStatus, UriInfo uriInfo) throws TigaseDBException {
        this.authRepository.setAccountStatus(jid, accountStatus);
        return UsersHandler.redirectToIndex(uriInfo);
    }

    @POST
    @Path(value="/{jid}/password")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response changePassword(@PathParam(value="jid") @NotEmpty BareJID jid, @FormParam(value="password") @NotBlank String password, @FormParam(value="password-confirm") @NotBlank String passwordConfirm, UriInfo uriInfo) throws TigaseDBException {
        if (!password.equals(passwordConfirm)) {
            throw new RuntimeException("Passwords do not match!");
        }
        this.authRepository.updateCredential(jid, "default", password);
        return UsersHandler.redirectToIndex(uriInfo);
    }

    public static Response redirectToIndex(UriInfo uriInfo) {
        return UsersHandler.redirectToIndex(uriInfo, null);
    }

    public static Response redirectToIndex(UriInfo uriInfo, String query) {
        return Response.seeOther((URI)uriInfo.getBaseUriBuilder().path(UsersHandler.class, "index").replaceQueryParam("query", new Object[]{query}).build(new Object[0])).build();
    }

    @POST
    @Path(value="/{jid}/qrCode")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"image/png"})
    public Response generateAuthQrCodePng(@PathParam(value="jid") @NotEmpty BareJID jid) throws IOException, WriterException, TigaseDBException {
        String token = this.generateAuthQrCodeToken(jid);
        return Response.ok((Object)this.encodeStringToQRCode(token), (String)"image/png").build();
    }

    @POST
    @Path(value="/{jid}/qrCode")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public QRCode generateAuthQrCodeJson(@PathParam(value="jid") @NotEmpty BareJID jid) throws IOException, WriterException, TigaseDBException {
        String token = this.generateAuthQrCodeToken(jid);
        byte[] qrcode = this.encodeStringToQRCode(token);
        return new QRCode(token, "data:image/png;base64," + Base64.encode((byte[])qrcode));
    }

    private byte[] encodeStringToQRCode(String token) throws IOException, WriterException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qrCodeWriter.encode(token.toString(), BarcodeFormat.QR_CODE, 300, 300, Map.of(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8, EncodeHintType.MARGIN, 0));
        MatrixToImageConfig imageConfig = new MatrixToImageConfig(-16777216, -1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)baos, (MatrixToImageConfig)imageConfig);
        return baos.toByteArray();
    }

    private String generateAuthQrCodeToken(BareJID jid) throws TigaseDBException {
        byte[] secret = new byte[32];
        this.secureRandom.nextBytes(secret);
        byte[] jidBytes = jid.toString().getBytes(StandardCharsets.UTF_8);
        byte[] data = new byte[secret.length + 1 + jidBytes.length];
        System.arraycopy(secret, 0, data, 0, secret.length);
        System.arraycopy(jidBytes, 0, data, secret.length + 1, jidBytes.length);
        String token = Base64.encode((byte[])data);
        this.authRepository.removeCredential(jid, "default");
        this.authRepository.updateCredential(jid, "default", "XTOKEN-HMAC-SHA-256", new XTokenCredentialsEntry(secret, true).encoded());
        return token;
    }

    public static class QRCode {
        private final String token;
        private final String png;

        public QRCode(String token, String png) {
            this.token = token;
            this.png = png;
        }

        public String getToken() {
            return this.token;
        }

        public String getPng() {
            return this.png;
        }
    }

    public record User(BareJID jid, AuthRepository.AccountStatus accountStatus) {
    }
}

