/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.admin.form;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import tigase.util.datetime.TimestampHelper;
import tigase.xml.Element;

public class Field {
    private static final TimestampHelper timestampHelper = new TimestampHelper();
    private final Element field;

    public Field(Element field) {
        this.field = field;
    }

    public String getType() {
        return Optional.ofNullable(this.field.getAttributeStaticStr("type")).orElse("text-single");
    }

    public String getSubType() {
        return this.field.getAttributeStaticStr("subtype");
    }

    public String getVar() {
        return this.field.getAttributeStaticStr("var");
    }

    public String getValue() {
        return this.field.getChildCData(new String[]{"field", "value"});
    }

    public LocalDateTime getDateTimeValue() {
        return Optional.ofNullable(this.field.getChildCDataStaticStr(new String[]{"field", "value"})).map(this::parseTimestamp).map(value -> LocalDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault())).orElse(null);
    }

    public LocalDate getDate() {
        return Optional.ofNullable(this.getDateTimeValue()).map(LocalDateTime::toLocalDate).orElse(null);
    }

    public String getDateString() {
        return Optional.ofNullable(this.getDate()).map(LocalDate::toString).orElse(null);
    }

    public LocalTime getTime() {
        return Optional.ofNullable(this.getDateTimeValue()).map(LocalDateTime::toLocalTime).orElse(null);
    }

    public String getTimeString() {
        return Optional.ofNullable(this.getTime()).map(LocalTime::toString).orElse(null);
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    private Date parseTimestamp(String text) {
        try {
            return timestampHelper.parseTimestamp(text);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public String getMultilineTextValue() {
        return Optional.ofNullable(this.field.getChildren(el -> el.getName() == "value")).orElse(Collections.emptyList()).stream().map(Element::getCData).collect(Collectors.joining("\n"));
    }

    public String getLabel() {
        return Optional.ofNullable(this.field.getAttributeStaticStr("label")).orElseGet(() -> this.field.getAttributeStaticStr("var"));
    }

    public boolean isChecked() {
        return Optional.ofNullable(this.getValue()).map(value -> "true".equals(value) || "1".equals(value)).orElse(false);
    }

    public boolean isRequired() {
        return this.field.getChild("required") != null;
    }

    public String getDesc() {
        return this.field.getChildCData(new String[]{"field", "desc"});
    }

    public boolean isMultiple() {
        return this.getType().contains("-multi");
    }

    public List<Option> getOptions() {
        List children = this.field.getChildren();
        if (children == null) {
            return Collections.emptyList();
        }
        return children.stream().filter(el -> el.getName() == "option").map(Option::new).collect(Collectors.toList());
    }

    public List<String> getValues() {
        return Optional.ofNullable(this.field.getChildren(el -> el.getName() == "value")).orElse(Collections.emptyList()).stream().map(Element::getCData).collect(Collectors.toList());
    }

    public boolean isSelected(Option option) {
        return this.getValues().contains(option.getValue());
    }

    public static class Option {
        private final Element option;

        public Option(Element option) {
            this.option = option;
        }

        public String getLabel() {
            return Optional.ofNullable(this.option.getAttributeStaticStr("label")).orElseGet(() -> this.getValue());
        }

        public String getValue() {
            return Optional.ofNullable(this.option.findChild(el -> el.getName() == "value")).map(Element::getCData).orElse(null);
        }
    }
}

