/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import tigase.disco.ServiceEntity;
import tigase.http.AbstractHttpModule;
import tigase.http.CommandManager;
import tigase.http.PacketWriter;
import tigase.http.modules.Module;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.server.Packet;
import tigase.server.script.CommandIfc;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class AbstractBareModule
extends AbstractHttpModule
implements Module,
Initializable,
ConfigurationChangedAware,
UnregisterAware {
    private static final ConcurrentHashMap<String, AbstractBareModule> modules = new ConcurrentHashMap();
    protected CommandManager commandManager = new CommandManager(this);
    @ConfigField(desc="Module name")
    protected String name;
    private String componentName;
    private JID jid;
    private ServiceEntity serviceEntity = null;
    private PacketWriter writer;

    public static <T extends Module> T getModuleByUUID(String uuid) {
        return (T)modules.get(uuid);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.contextPath = "/" + name;
    }

    @Override
    public boolean sendPacket(Packet packet) {
        return this.writer.write(this, packet);
    }

    @Override
    public CompletableFuture<Packet> sendPacketAndWait(Packet packet, Integer timeout) {
        return this.writer.write(this, packet, timeout);
    }

    public void everyHour() {
    }

    public void everyMinute() {
    }

    public void everySecond() {
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/commands"};
    }

    @Override
    public boolean processPacket(Packet packet) {
        if (packet.isCommand()) {
            return this.commandManager.execute(packet);
        }
        return false;
    }

    @Override
    public Element getDiscoInfo(String node, boolean isAdmin) {
        return this.serviceEntity.getDiscoInfo(node, isAdmin);
    }

    @Override
    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        if (jid.getLocalpart() == null) {
            return Collections.singletonList(this.serviceEntity.getDiscoItem(node, String.valueOf(this.getName()) + "@" + jid.toString()));
        }
        if (node != null && node.equals("http://jabber.org/protocol/commands") && this.isAdmin(from.getBareJID())) {
            LinkedList<Element> result = new LinkedList<Element>();
            for (CommandIfc comm : this.commandManager.getCommands()) {
                Element item = new Element("item", new String[]{"node", "name", "jid"}, new String[]{comm.getCommandId(), comm.getDescription(), jid.toString()});
                if (comm.getGroup() != null) {
                    item.setAttribute("group", comm.getGroup());
                }
                result.add(item);
            }
            return result;
        }
        return this.serviceEntity.getItems(node, jid.toString());
    }

    @Override
    public JID getJid() {
        return this.jid;
    }

    public void getStatistics(String compName, StatisticsList list) {
    }

    public void setStatisticsPrefix(String prefix) {
    }

    public void statisticExecutedIn(long executionTime) {
    }

    @Override
    public void init(JID jid, String componentName, PacketWriter writer) {
        this.componentName = componentName;
        this.jid = JID.jidInstanceNS((String)this.getName(), (String)jid.getDomain(), null);
        this.writer = writer;
    }

    @Override
    public void initBindings(Bindings binds) {
        binds.put("module", (Object)this);
    }

    @Override
    public boolean isAdmin(BareJID user) {
        return this.writer.isAdmin(JID.jidInstance((BareJID)user));
    }

    @Override
    public void start() {
        modules.put(this.uuid, this);
    }

    @Override
    public void stop() {
        modules.remove(this.uuid, this);
    }

    public void executedIn(String path, long executionTime) {
    }

    @Override
    public void initialize() {
        super.initialize();
        this.serviceEntity = new ServiceEntity(this.getName(), null, this.getDescription(), null, true);
        this.serviceEntity.setFeatures(this.getFeatures());
    }

    protected String getComponentName() {
        return this.componentName;
    }
}

