/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.json;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JsonSerializer {
    public String serialize(Object value) {
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof List) {
            return "[" + ((List)value).stream().map(this::serialize).collect(Collectors.joining(",")) + "]";
        }
        if (value instanceof Map) {
            return "{" + ((Map)value).entrySet().stream().map(e -> "\"" + e.getKey() + "\" : " + this.serialize(e.getValue())).collect(Collectors.joining(",")) + "}";
        }
        if (value != null) {
            return JsonSerializer.escapeString(value.toString());
        }
        return "null";
    }

    public static String escapeString(String in) {
        return "\"" + in.replace("\"", "\\\"").replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r").replace("\b", "\\b").replace("\t", "\\t") + "\"";
    }
}

