/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.json;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;

public class JsonParser {
    private char[] chars;
    private int i = 0;

    public static Object parseJson(String text) throws InvalidJsonException {
        return new JsonParser().parse(text);
    }

    public static Object parseJson(byte[] data) throws InvalidJsonException {
        return JsonParser.parseJson(data, StandardCharsets.UTF_8);
    }

    public static Object parseJson(byte[] data, Charset charset) throws InvalidJsonException {
        return JsonParser.parseJson(new String(data, charset));
    }

    public void skipWhitespaces() throws InvalidJsonException {
        while (this.i < this.chars.length && Character.isWhitespace(this.chars[this.i])) {
            ++this.i;
        }
        if (this.i == this.chars.length) {
            throw new InvalidJsonException("Unexpected end of input");
        }
    }

    private List readList() throws InvalidJsonException {
        ++this.i;
        ArrayList<Object> list = new ArrayList<Object>();
        while (this.i < this.chars.length && this.chars[this.i] != ']') {
            if (list.isEmpty()) {
                list.add(this.readValue());
                continue;
            }
            this.skipWhitespaces();
            if (this.chars[this.i] != ',') {
                throw new InvalidJsonException("Got '" + this.chars[this.i] + "' but expected ',' at " + this.i);
            }
            ++this.i;
            list.add(this.readValue());
            this.skipWhitespaces();
        }
        ++this.i;
        return list;
    }

    private Object readObject() throws InvalidJsonException {
        this.skipWhitespaces();
        if (this.chars[this.i] != '{') {
            throw new InvalidJsonException("Got '" + this.chars[this.i] + "' but expected '{' at " + this.i);
        }
        ++this.i;
        LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
        this.skipWhitespaces();
        while (this.i < this.chars.length && this.chars[this.i] != '}') {
            if (!object.isEmpty()) {
                this.skipWhitespaces();
                if (this.i < this.chars.length && this.chars[this.i] != ',') {
                    throw new InvalidJsonException("Got '" + this.chars[this.i] + "' but expected ',' at " + this.i);
                }
                ++this.i;
            }
            String key = this.readString();
            this.skipWhitespaces();
            if (this.i >= this.chars.length) {
                throw new InvalidJsonException("Unexpected end of input");
            }
            if (this.chars[this.i] != ':') {
                throw new InvalidJsonException("Got '" + this.chars[this.i] + "' but expected ':' at " + this.i);
            }
            ++this.i;
            if (this.i >= this.chars.length) {
                throw new InvalidJsonException("Unexpected end of input");
            }
            Object value = this.readValue();
            object.put(key, value);
            this.skipWhitespaces();
        }
        ++this.i;
        return object;
    }

    private Object readValue() throws InvalidJsonException {
        this.skipWhitespaces();
        char c = this.chars[this.i];
        return switch (c) {
            case ',' -> throw new InvalidJsonException("Unexpected ','");
            case '\"', '\'' -> this.readQuotedString(c);
            case '{' -> this.readObject();
            case '[' -> this.readList();
            default -> this.readPrimitiveValue();
        };
    }

    private Object readPrimitiveValue() throws InvalidJsonException {
        String string;
        return switch (string = this.readUnquotedString()) {
            case "true" -> Boolean.TRUE;
            case "false" -> Boolean.FALSE;
            case "null" -> null;
            default -> {
                char c1 = string.charAt(0);
                if (Character.isDigit(c1) || c1 == '-' || c1 == '+') {
                    if (string.contains(".")) {
                        yield Double.parseDouble(string);
                    }
                    long value = Long.parseLong(string);
                    if (value < Integer.MAX_VALUE) {
                        yield (int)value;
                    }
                    yield value;
                }
                yield string;
            }
        };
    }

    private String readQuotedString(char quoteChar) throws InvalidJsonException {
        ++this.i;
        if (this.i >= this.chars.length) {
            throw new InvalidJsonException("Unexpected end of input");
        }
        StringBuilder sb = new StringBuilder();
        while (this.i < this.chars.length && this.chars[this.i] != quoteChar) {
            if (this.chars[this.i] == '\\') {
                ++this.i;
                if (this.i >= this.chars.length) {
                    throw new InvalidJsonException("Unexpected end of input");
                }
                switch (this.chars[this.i]) {
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case '/': {
                        sb.append('/');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'u': {
                        sb.append(this.decodeU());
                        break;
                    }
                    case '\"': {
                        sb.append("\"");
                        break;
                    }
                    case '\'': {
                        sb.append("'");
                        break;
                    }
                    default: {
                        sb.append(this.chars[this.i]);
                    }
                }
                ++this.i;
                continue;
            }
            sb.append(this.chars[this.i]);
            ++this.i;
        }
        String str = sb.toString();
        ++this.i;
        return str;
    }

    private char decodeU() throws InvalidJsonException {
        ++this.i;
        int start = this.i;
        int end = this.i + 4;
        this.i += 3;
        if (this.i >= this.chars.length) {
            throw new InvalidJsonException("Unexpected end of input");
        }
        return (char)Integer.parseInt(new String(Arrays.copyOfRange(this.chars, start, end)), 16);
    }

    private String readUnquotedString() throws InvalidJsonException {
        if (this.i >= this.chars.length) {
            throw new InvalidJsonException("Unexpected end of input");
        }
        int start = this.i;
        while (this.i < this.chars.length && !Character.isWhitespace(this.chars[this.i]) && this.chars[this.i] != ':' && this.chars[this.i] != ',' && this.chars[this.i] != '}') {
            ++this.i;
        }
        return new String(Arrays.copyOfRange(this.chars, start, this.i));
    }

    private String readString() throws InvalidJsonException {
        this.skipWhitespaces();
        if (this.i >= this.chars.length) {
            throw new InvalidJsonException("Unexpected end of input");
        }
        char c = this.chars[this.i];
        if (c == '\'' || c == '\"') {
            return this.readQuotedString(c);
        }
        return this.readUnquotedString();
    }

    public Object parse(String input) throws InvalidJsonException {
        this.chars = input.toCharArray();
        this.i = 0;
        return this.readObject();
    }

    public static class InvalidJsonException
    extends Exception {
        public InvalidJsonException(String message) {
            super(message);
        }
    }

    static enum State {
        READ_OBJECT,
        READ_KEY,
        READ_VALUE;

    }
}

