/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.regex.Matcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ValidationException;
import tigase.http.api.HttpException;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.HttpMethod;
import tigase.http.jaxrs.JaxRsModule;
import tigase.http.jaxrs.JaxRsRequestHandler;
import tigase.http.jaxrs.RequestHandler;
import tigase.http.jaxrs.annotations.LoginForm;
import tigase.http.modules.AbstractBareModule;
import tigase.http.modules.rest.OldGroovyRequestHandler;

public class JaxRsServlet<M extends JaxRsModule>
extends HttpServlet {
    public static Comparator<RequestHandler> REQUEST_HANDLER_COMPARATOR = Comparator.comparing(requestHandler -> {
        if (requestHandler instanceof JaxRsRequestHandler) {
            return 1;
        }
        if (requestHandler instanceof OldGroovyRequestHandler) {
            return 2;
        }
        return 3;
    });
    public static final String MODULE_KEY = "module-uuid";
    protected ScheduledExecutorService executorService;
    protected M module;
    protected ConcurrentHashMap<HttpMethod, CopyOnWriteArrayList<RequestHandler>> requestHandlers = new ConcurrentHashMap();
    private String loginFormPath;

    protected boolean canAccess(RequestHandler requestHandler, HttpServletRequest request, HttpServletResponse response) throws HttpException, IOException, ServletException {
        Handler.Role requiredRole = requestHandler.getRequiredRole();
        if (requiredRole.isAuthenticationRequired()) {
            if (!request.isUserInRole(requiredRole.name().toLowerCase())) {
                if (this.loginFormPath != null && Optional.ofNullable(request.getHeader("Accept")).stream().flatMap(str -> Arrays.stream(str.split(","))).anyMatch(part -> part.contains("text/html"))) {
                    response.sendRedirect(String.valueOf(request.getContextPath()) + this.loginFormPath);
                } else {
                    response.setHeader("WWW-Authenticate", "Basic realm=\"TigasePlain\"");
                    request.authenticate(response);
                }
                return false;
            }
            this.module.getAuthProvider().refreshJwtToken(request, response);
        }
        return true;
    }

    public void init() throws ServletException {
        super.init();
        ServletConfig cfg = super.getServletConfig();
        String moduleName = cfg.getInitParameter(MODULE_KEY);
        this.module = (JaxRsModule)AbstractBareModule.getModuleByUUID(moduleName);
        this.executorService = this.module.getExecutorService();
        List handlers = this.module.getHandlers();
        if (handlers != null) {
            for (Handler handler : handlers) {
                this.registerHandlers(JaxRsRequestHandler.create(handler));
            }
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            HttpMethod httpMethod = HttpMethod.valueOf(req.getMethod());
            List handlers = this.requestHandlers.get((Object)httpMethod);
            if (handlers != null) {
                Matcher matcher;
                String requestUri = req.getRequestURI();
                if (!req.getContextPath().equals("/") && !req.getContextPath().isEmpty()) {
                    requestUri = requestUri.substring(req.getContextPath().length());
                }
                for (RequestHandler handler : handlers) {
                    matcher = handler.test(req, requestUri);
                    if (matcher == null || !matcher.matches()) continue;
                    if (this.canAccess(handler, req, resp)) {
                        handler.execute(req, resp, matcher, this.executorService);
                    }
                    return;
                }
                if (requestUri.isEmpty()) {
                    requestUri = "/";
                    for (RequestHandler handler : handlers) {
                        matcher = handler.test(req, requestUri);
                        if (matcher == null || !matcher.matches()) continue;
                        if (this.canAccess(handler, req, resp)) {
                            handler.execute(req, resp, matcher, this.executorService);
                        }
                        return;
                    }
                }
            }
            resp.sendError(404, "Not found");
        }
        catch (ValidationException ex) {
            resp.sendError(406, ex.getMessage());
        }
        catch (HttpException ex) {
            resp.sendError(ex.getCode(), ex.getMessage());
        }
    }

    protected void registerHandlers(Collection<? extends RequestHandler> requestHandlers) {
        for (RequestHandler requestHandler : requestHandlers) {
            this.registerHandler(requestHandler);
        }
    }

    protected void registerHandler(RequestHandler requestHandler) {
        JaxRsRequestHandler jaxRsRequestHandler;
        List handlers = this.requestHandlers.computeIfAbsent(requestHandler.getHttpMethod(), x -> new CopyOnWriteArrayList());
        handlers.add(requestHandler);
        handlers.sort(Comparator.comparing(Function.identity()));
        if (requestHandler instanceof JaxRsRequestHandler && (jaxRsRequestHandler = (JaxRsRequestHandler)requestHandler).getMethod().isAnnotationPresent(LoginForm.class)) {
            this.loginFormPath = jaxRsRequestHandler.getPattern().pattern();
        }
    }
}

