/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import tigase.http.jaxrs.MultivaluedMapImpl;
import tigase.http.jaxrs.SecurityContextImpl;
import tigase.http.jaxrs.UriInfoImpl;

public class ContainerRequestContext {
    private static ThreadLocal<ContainerRequestContext> contexts = new ThreadLocal();
    private final HttpServletRequest request;
    private MultivaluedMap<String, String> headers;
    private SecurityContext securityContext;
    private UriInfo uriInfo;

    public static void setContext(ContainerRequestContext context) {
        contexts.set(context);
    }

    public static void resetContext() {
        contexts.remove();
    }

    public static ContainerRequestContext getContext() {
        return contexts.get();
    }

    public ContainerRequestContext(HttpServletRequest request) {
        this.request = request;
    }

    public MultivaluedMap<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = new MultivaluedMapImpl();
            Enumeration headerNames = this.request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                this.headers.putSingle((Object)name, (Object)this.request.getHeader(name));
            }
        }
        return this.headers;
    }

    public String getHeaderString(String name) {
        return this.request.getHeader(name);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public SecurityContext getSecurityContext() {
        if (this.securityContext == null) {
            this.securityContext = new SecurityContextImpl(this.request);
        }
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public UriInfo getUriInfo() {
        if (this.uriInfo == null) {
            String basePath = this.request.getContextPath();
            String servletPath = this.request.getServletPath();
            if (!servletPath.isEmpty() && basePath.endsWith("/") && servletPath.startsWith("/")) {
                basePath = String.valueOf(basePath) + servletPath.substring(1);
            }
            this.uriInfo = new UriInfoImpl(this.request, basePath);
        }
        return this.uriInfo;
    }
}

