/*
 * Decompiled with CFR 0.152.
 */
package tigase.http;

import groovy.lang.Closure;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import tigase.auth.credentials.Credentials;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.http.modules.AbstractBareModule;
import tigase.http.modules.AbstractModule;
import tigase.http.modules.rest.RestModule;
import tigase.http.rest.Service;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

public class ServiceImpl<T extends RestModule>
implements Service<T> {
    private final T module;

    public ServiceImpl(String moduleUUID) {
        this((RestModule)AbstractBareModule.getModuleByUUID(moduleUUID));
    }

    public ServiceImpl(T module) {
        this.module = module;
    }

    @Override
    public boolean sendPacket(Packet packet) {
        return ((AbstractBareModule)this.module).sendPacket(packet);
    }

    @Override
    public CompletableFuture<Packet> sendPacketAndWait(Packet packet, Integer timeout) {
        return ((AbstractBareModule)this.module).sendPacketAndWait(packet, timeout == null ? null : Integer.valueOf(timeout));
    }

    @Override
    public void sendPacket(Packet packet, Long timeout, Closure closure) {
        if (closure != null) {
            ((CompletableFuture)this.sendPacketAndWait(packet, timeout != null ? Integer.valueOf(timeout.intValue()) : null).exceptionally(ex -> null)).thenApply(result -> closure.call(result));
        } else {
            this.sendPacket(packet);
        }
    }

    @Override
    public UserRepository getUserRepository() {
        return ((AbstractModule)this.module).getUserRepository();
    }

    @Override
    public AuthRepository getAuthRepository() {
        return ((AbstractModule)this.module).getAuthRepository();
    }

    @Override
    public boolean isAdmin(BareJID user) {
        return ((AbstractBareModule)this.module).isAdmin(user);
    }

    @Override
    public boolean isAllowed(String key, String domain, String path) {
        return ((RestModule)this.module).isRequestAllowed(key, domain, path);
    }

    @Override
    public boolean checkCredentials(String user, String password) throws TigaseStringprepException, TigaseDBException, AuthorizationException {
        BareJID jid = BareJID.bareJIDInstance((String)user);
        Credentials credentials = ((AbstractModule)this.module).getAuthRepository().getCredentials(jid, "default");
        if (credentials == null) {
            return false;
        }
        return !credentials.isAccountDisabled() && Optional.ofNullable(credentials.getFirst()).map(e -> e.verifyPlainPassword(password)).orElse(false) != false;
    }

    @Override
    public T getModule() {
        return this.module;
    }
}

