/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dnswebservice;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tigase.http.modules.dnswebservice.DnsEntry;
import tigase.http.modules.dnswebservice.DnsItem;
import tigase.http.modules.dnswebservice.DnsResolver;

public class DnsHostMetaServlet
extends HttpServlet {
    public String getServletInfo() {
        return "Short description";
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Format format = Optional.ofNullable(this.getInitParameter("format")).map(Format::valueOf).or(() -> Optional.ofNullable(request.getPathInfo()).map(path -> path.startsWith("/host-meta.json")).map(v -> v != false ? Format.json : Format.xml)).orElse(Format.xml);
        String domain = Optional.ofNullable(request.getHeader("domain")).orElse(Optional.of(request.getServerName()).map(str -> str.split(":")).map(arr -> arr[0]).get());
        try (PrintWriter out = null;){
            DnsItem item = DnsResolver.get(domain);
            if (item == null) {
                response.sendError(404);
            } else {
                response.setHeader("Access-Control-Allow-Origin", "*");
                StringBuilder sb = new StringBuilder(1000);
                Stream<BoshLink> urlsStream = Stream.concat(Optional.ofNullable(item.getWebSocket()).map(Arrays::stream).orElse(Stream.empty()).map(DnsEntry::getURL).filter(Objects::nonNull).map(arg_0 -> WebSocketLink.new(this, arg_0)), Optional.ofNullable(item.getBosh()).map(Arrays::stream).orElse(Stream.empty()).map(DnsEntry::getURL).filter(Objects::nonNull).map(arg_0 -> BoshLink.new(this, arg_0)));
                switch (format) {
                    case xml: {
                        response.setContentType("application/xml");
                        out = response.getWriter();
                        sb.append("<?xml version='1.0' encoding='utf-8'?>\n<XRD xmlns='http://docs.oasis-open.org/ns/xri/xrd-1.0'>");
                        sb.append(urlsStream.map(Link::toXML).collect(Collectors.joining()));
                        sb.append("</XRD>");
                        break;
                    }
                    case json: {
                        response.setContentType("application/json");
                        out = response.getWriter();
                        String callback = request.getParameter("callback");
                        if (callback != null) {
                            sb.append(callback);
                            sb.append("(");
                        }
                        sb.append("{ \"links\": [");
                        sb.append(urlsStream.map(Link::toJSON).collect(Collectors.joining(",")));
                        sb.append("]}");
                        if (callback == null) break;
                        sb.append(")");
                    }
                }
                out.append(sb.toString());
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    class AbstractLink
    implements Link {
        final String type;
        final String url;

        AbstractLink(String type, String url) {
            this.type = type;
            this.url = url;
        }

        @Override
        public String getURL() {
            return this.url;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String toJSON() {
            return "{\"rel\": \"" + this.getType() + "\", \"href\": \"" + this.getURL() + "\"}";
        }

        @Override
        public String toXML() {
            return "<Link rel=\"" + this.getType() + "\" href=\"" + this.getURL() + "\" />";
        }
    }

    class BoshLink
    extends AbstractLink {
        BoshLink(String url) {
            super("urn:xmpp:alt-connections:xbosh", url);
        }
    }

    static enum Format {
        json,
        xml;

    }

    static interface Link {
        public String getType();

        public String getURL();

        public String toJSON();

        public String toXML();
    }

    class WebSocketLink
    extends AbstractLink {
        WebSocketLink(String url) {
            super("urn:xmpp:alt-connections:websocket", url);
        }
    }
}

