/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.upload.db.derby;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Logger;

public class StoredProcedures {
    private static final Logger log = Logger.getLogger(StoredProcedures.class.getCanonicalName());

    public static void allocateSlot(String slotId, String uploader, String domain, String res, String filename, Long filesize, String contentType, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement stmt = conn.prepareStatement("insert into tig_hfu_slots( slot_id, uploader, domain, res, filename, filesize, content_type, ts, status ) values (?, ?, ?, ?, ?, ?, ?, ?, 0)");
            stmt.setString(1, slotId);
            stmt.setString(2, uploader);
            stmt.setString(3, domain);
            stmt.setString(4, res);
            stmt.setString(5, filename);
            stmt.setLong(6, filesize);
            stmt.setString(7, contentType);
            stmt.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
            stmt.execute();
            data[0] = conn.createStatement().executeQuery("select '" + slotId + "' as slot_id from SYSIBM.SYSDUMMY1");
        }
    }

    public static void getSlot(String slotId, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement stmt = conn.prepareStatement("select uploader, slot_id, filename, filesize, content_type, ts from tig_hfu_slots where slot_id = ?");
            stmt.setString(1, slotId);
            data[0] = stmt.executeQuery();
        }
    }

    public static void listExpiredSlots(String domain, Timestamp ts, Integer max, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement stmt = conn.prepareStatement("select uploader, slot_id, filename, filesize, content_type, ts from tig_hfu_slots where domain = ? and ts < ? order by ts offset 0 rows fetch next ? rows only");
            stmt.setString(1, domain);
            stmt.setTimestamp(2, ts);
            stmt.setInt(3, max);
            data[0] = stmt.executeQuery();
        }
    }

    public static void removeExpiredSlots(String domain, Timestamp ts, Integer max) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            ArrayList<String> slots = new ArrayList<String>();
            PreparedStatement stmt = conn.prepareStatement("select slot_id from tig_hfu_slots where domain = ? and ts < ? order by ts offset 0 rows fetch next ? rows only");
            stmt.setString(1, domain);
            stmt.setTimestamp(2, ts);
            stmt.setInt(3, max);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                slots.add(rs.getString(1));
            }
            rs.close();
            if (!slots.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("delete from tig_hfu_slots where slot_id IN (");
                boolean first = true;
                for (String slot : slots) {
                    if (!first) {
                        sb.append(',');
                    } else {
                        first = false;
                    }
                    sb.append('\'');
                    sb.append(slot);
                    sb.append('\'');
                }
                sb.append(")");
                conn.createStatement().execute(sb.toString());
            }
        }
    }

    public static void updateSlot(String slotId) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement stmt = conn.prepareStatement("update tig_hfu_slots set status = 1 where slot_id = ?");
            stmt.setString(1, slotId);
            stmt.execute();
        }
    }

    public static void usedSpaceCountForUser(String jid, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement stmt = conn.prepareStatement("select sum(filesize) from tig_hfu_slots where uploader = ?");
            stmt.setString(1, jid);
            data[0] = stmt.executeQuery();
        }
    }

    public static void usedSpaceCountForDomain(String domain, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement stmt = conn.prepareStatement("select sum(filesize) from tig_hfu_slots where domain = ?");
            stmt.setString(1, domain);
            data[0] = stmt.executeQuery();
        }
    }

    public static void userSlotsQuery(String jid, String afterId, Integer maxLimit, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            if (afterId == null) {
                PreparedStatement stmt = conn.prepareStatement("select slot_id, filename, filesize, content_type, ts, uploader from tig_hfu_slots where uploader = ? order by ts asc fetch first ? rows only");
                stmt.setString(1, jid);
                stmt.setInt(2, maxLimit);
                data[0] = stmt.executeQuery();
            } else {
                PreparedStatement stmt = conn.prepareStatement("select slot_id, filename, filesize, content_type, ts, uploader from tig_hfu_slots where uploader = ? and ts > ( select ts from tig_hfu_slots where slot_id = ? ) order by ts asc fetch first ? rows only");
                stmt.setString(1, jid);
                stmt.setString(2, afterId);
                stmt.setInt(3, maxLimit);
                data[0] = stmt.executeQuery();
            }
        }
    }

    public static void domainSlotsQuery(String domain, String afterId, Integer maxLimit, ResultSet[] data) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            if (afterId == null) {
                PreparedStatement stmt = conn.prepareStatement("select slot_id, filename, filesize, content_type, ts, uploader from tig_hfu_slots where domain = ? order by ts asc fetch first ? rows only");
                stmt.setString(1, domain);
                stmt.setInt(2, maxLimit);
                data[0] = stmt.executeQuery();
            } else {
                PreparedStatement stmt = conn.prepareStatement("select slot_id, filename, filesize, content_type, ts, uploader from tig_hfu_slots where domain = ? and ts > ( select ts from tig_hfu_slots where slot_id = ? ) order by ts asc fetch first ? rows only");
                stmt.setString(1, domain);
                stmt.setString(2, afterId);
                stmt.setInt(3, maxLimit);
                data[0] = stmt.executeQuery();
            }
        }
    }

    public static void removeSlot(String slotId) throws SQLException {
        conn.setTransactionIsolation(2);
        try (Connection conn = DriverManager.getConnection("jdbc:default:connection");){
            PreparedStatement stmt = conn.prepareStatement("delete from tig_hfu_slots where slot_id = ?");
            stmt.setString(1, slotId);
            stmt.execute();
        }
    }
}

