/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.wellknown;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.http.DeploymentInfo;
import tigase.http.HttpMessageReceiver;
import tigase.http.ServletInfo;
import tigase.http.modules.AbstractModule;
import tigase.http.modules.wellknown.HostMetaServlet;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.server.MessageRouter;
import tigase.server.bosh.BoshConnectionManager;
import tigase.server.websocket.WebSocketClientConnectionManager;

@Bean(name="well-known", parent=HttpMessageReceiver.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode, ConfigTypeEnum.SessionManagerMode, ConfigTypeEnum.ConnectionManagersMode, ConfigTypeEnum.ComponentMode})
public class WellKnownModule
extends AbstractModule
implements RegistrarBean {
    private DeploymentInfo deployment = null;
    @ConfigField(desc="Hostname for establishing WS/Bosh connections")
    private String hostname = null;
    private Kernel kernel;
    private List<ServletInfo> wellKnownServlets = List.of(new ServletInfo("HostMeta", HostMetaServlet.class).addMapping("/host-meta").addInitParam("format", "xml"), new ServletInfo("HostMeta", HostMetaServlet.class).addMapping("/host-meta.json").addInitParam("format", "json"));

    @Override
    public String getDescription() {
        return "Support for /.well-known/";
    }

    @Override
    public void register(Kernel kernel) {
        this.kernel = kernel;
        super.register(kernel);
    }

    @Override
    public void unregister(Kernel kernel) {
        super.unregister(kernel);
        this.kernel = null;
    }

    @Override
    public void start() {
        if (this.deployment != null) {
            this.stop();
        }
        for (ServletInfo info : this.wellKnownServlets) {
            info.addInitParam("module-id-key", this.uuid);
        }
        this.deployment = this.httpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath("/.well-known").setDeploymentName("Well-Known").setDeploymentDescription(this.getDescription()).addServlets((ServletInfo[])this.wellKnownServlets.toArray(ServletInfo[]::new));
        super.start();
        if (this.vhosts != null) {
            this.deployment.setVHosts(this.vhosts);
        }
        this.httpServer.deploy(this.deployment);
    }

    @Override
    public void stop() {
        if (this.deployment != null) {
            this.httpServer.undeploy(this.deployment);
            this.deployment = null;
        }
        super.stop();
    }

    public List<HostMetaServlet.Link> getHostMetaLinks(String domain) {
        Optional.ofNullable(this.hostname).orElse(domain);
        Kernel kernel = this.kernel;
        while (kernel.getParent() != null) {
            kernel = kernel.getParent();
        }
        MessageRouter router = (MessageRouter)kernel.getInstance(MessageRouter.class);
        Stream<HostMetaServlet.Link> wsLinks = router.getComponentsAll().stream().filter(it -> it instanceof WebSocketClientConnectionManager).map(WebSocketClientConnectionManager.class::cast).flatMap(it -> Arrays.stream(it.getPortsConfigBean().getPortsBeans())).map(it -> String.valueOf(it.isSecure() ? "wss" : "ws") + "://" + domain + ":" + it.getPort() + "/").map(HostMetaServlet.WebSocketLink::new);
        Stream<HostMetaServlet.Link> boshLinks = router.getComponentsAll().stream().filter(it -> it instanceof BoshConnectionManager).map(BoshConnectionManager.class::cast).flatMap(it -> Arrays.stream(it.getPortsConfigBean().getPortsBeans())).map(it -> String.valueOf(it.isSecure() ? "https" : "http") + "://" + domain + ":" + it.getPort() + "/").map(HostMetaServlet.BoshLink::new);
        return Stream.concat(wsLinks, boshLinks).collect(Collectors.toList());
    }
}

