/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup.pages;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import tigase.db.util.DBSchemaLoader;
import tigase.db.util.SchemaLoader;
import tigase.http.modules.setup.Config;
import tigase.http.modules.setup.pages.Page;
import tigase.http.modules.setup.questions.Question;
import tigase.http.modules.setup.questions.SingleAnswerQuestion;

public class DBSetupPage
extends Page {
    private final Config config;
    private List<Question> questions = new ArrayList<Question>();

    public DBSetupPage(Config config) {
        super("Database configuration", "dbSetup.html", new Question[0]);
        this.config = config;
    }

    @Override
    public void beforeDisplay() {
        List options = SchemaLoader.newInstance((String)this.config.getDbType()).getSetupOptions();
        Stream<Question> questions = options.stream().filter(param -> !DBSchemaLoader.PARAMETERS_ENUM.ROOT_ASK.getName().equals(param.getFullName().orElse(null))).map(o -> {
            SingleAnswerQuestion question = null;
            if (Boolean.class.equals((Object)o.getType())) {
                question = new SingleAnswerQuestion((String)o.getFullName().get(), (String)o.getDescription().get(), () -> {
                    String val = this.config.dbProperties.getProperty((String)o.getFullName().get());
                    if (val == null) {
                        val = o.getDefaultValue().orElse(null);
                    }
                    return val;
                }, val -> {
                    boolean bval = val != null ? Boolean.parseBoolean(val) || "on".equals(val) : false;
                    this.config.dbProperties.setProperty((String)o.getFullName().get(), String.valueOf(bval));
                });
            } else {
                question = new SingleAnswerQuestion((String)o.getFullName().get(), (String)o.getDescription().get(), o.isRequired(), () -> {
                    String val = this.config.dbProperties.getProperty((String)o.getFullName().get());
                    if (val == null) {
                        val = o.getDefaultValue().orElse(null);
                    }
                    return val;
                }, val -> {
                    if (val == null || val.trim().isEmpty()) {
                        this.config.dbProperties.remove(o.getFullName().get());
                    } else {
                        this.config.dbProperties.setProperty((String)o.getFullName().get(), (String)val);
                    }
                });
                question.setSecret(o.isSecret());
            }
            return question;
        });
        this.questions.clear();
        this.setQuestions(questions);
    }

    public List<Question> getQuestions() {
        return this.questions;
    }

    @Override
    protected void addQuestion(Question question) {
        super.addQuestion(question);
        this.questions.add(question);
    }
}

