/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.http.modules.setup.Config;
import tigase.http.modules.setup.pages.AdvancedConfigPage;
import tigase.http.modules.setup.pages.Page;
import tigase.http.modules.setup.questions.Question;
import tigase.http.modules.setup.questions.SingleAnswerQuestion;
import tigase.server.BasicComponent;
import tigase.util.setup.BeanDefinition;
import tigase.util.setup.SetupHelper;

public class AdvConfigPage
extends Page
implements AdvancedConfigPage {
    private final Config config;
    private List<ComponentQuestion> optionalComponents = new ArrayList<ComponentQuestion>();

    public AdvConfigPage(Config config) {
        super("Advanced configuration options", "advConfig.html", Stream.of(new SingleAnswerQuestion("clusterMode", () -> String.valueOf(config.getClusterMode()), val -> config.setClusterMode(val != null ? Boolean.parseBoolean(val) || "on".equals(val) : false)), new SingleAnswerQuestion("acsComponent", () -> String.valueOf(config.getACS()), val -> config.setACS(val != null ? Boolean.parseBoolean(val) || "on".equals(val) : false))));
        this.config = config;
        this.optionalComponents = SetupHelper.getAvailableComponents().stream().filter(def -> !def.isCoreComponent()).map(def -> new ComponentQuestion((BeanDefinition)def, config)).sorted(ComponentQuestion.byBeanName).collect(Collectors.toList());
        this.optionalComponents.forEach(this::addQuestion);
    }

    public List<Question> getOptionalComponents() {
        return Collections.unmodifiableList(this.optionalComponents);
    }

    @Override
    public void setValues(Map<String, String[]> params) {
        super.setValues(params);
        if (this.config.getClusterMode() && (this.config.optionalComponents.contains("muc") || this.config.optionalComponents.contains("pubsub"))) {
            this.config.setACS(true);
        }
    }

    private static class ComponentQuestion
    extends SingleAnswerQuestion {
        private static final Comparator<ComponentQuestion> byBeanName = (e1, e2) -> e1.getBeanName().compareTo(e2.getBeanName());
        private final BeanDefinition def;

        ComponentQuestion(BeanDefinition def, Config config) {
            super(def.getName(), () -> config.optionalComponents.contains(def.getName()) ? def.getName() : null, val -> {
                if (val != null && (Boolean.parseBoolean(val) || "on".equals(val))) {
                    config.optionalComponents.add(def.getName());
                } else {
                    config.optionalComponents.remove(def.getName());
                }
            });
            this.def = def;
        }

        @Override
        public String getLabel() {
            String desc = this.def.getName();
            try {
                desc = ((BasicComponent)this.def.getClazz().newInstance()).getDiscoDescription();
            }
            catch (Exception exception) {}
            return desc;
        }

        public String getBeanName() {
            return this.def.getName();
        }
    }
}

