/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.upload.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.util.RepositoryVersionAware;
import tigase.http.upload.db.FileUploadRepository;
import tigase.kernel.beans.config.ConfigField;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
@Repository.SchemaId(id="http-api", name="Tigase HTTP API - File Upload")
public class JDBCFileUploadRepository
implements FileUploadRepository<DataRepository>,
RepositoryVersionAware {
    private static final String DEF_ALLOCATE_SLOT = "{ call Tig_HFU_AllocateSlot(?, ?, ?, ?, ?, ?, ?) }";
    private static final String DEF_UPDATE_SLOT = "{ call Tig_HFU_UpdateSlot(?) }";
    private static final String DEF_GET_SLOT = "{ call Tig_HFU_GetSlot(?) }";
    private static final String DEF_LIST_EXPIRED_SLOTS = "{ call Tig_HFU_ListExpiredSlots(?,?,?) }";
    private static final String DEF_REMOVE_EXPIRED_SLOTS = "{ call Tig_HFU_RemoveExpiredSlots(?,?,?) }";
    @ConfigField(desc="Query to allocate slot", alias="allocate-slot-query")
    private String ALLOCATE_SLOT_QUERY = "{ call Tig_HFU_AllocateSlot(?, ?, ?, ?, ?, ?, ?) }";
    @ConfigField(desc="Query to retrieve slot metadata", alias="get-slot-query")
    private String GET_SLOT_QUERY = "{ call Tig_HFU_GetSlot(?) }";
    @ConfigField(desc="Query to list expired slots", alias="list-expired-slots-query")
    private String LIST_EXPIRED_SLOTS_QUERY = "{ call Tig_HFU_ListExpiredSlots(?,?,?) }";
    @ConfigField(desc="Query to remove expired slots", alias="remove-expired-slots-query")
    private String REMOVE_EXPIRED_SLOTS_QUERY = "{ call Tig_HFU_RemoveExpiredSlots(?,?,?) }";
    @ConfigField(desc="Query to update slot on file upload", alias="update-slot-query")
    private String UPDATE_SLOT_QUERY = "{ call Tig_HFU_UpdateSlot(?) }";
    private DataRepository repo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileUploadRepository.Slot allocateSlot(JID sender, String slotId, String filename, long filesize, String contentType) throws TigaseDBException {
        BareJID bareJid = sender.getBareJID();
        try {
            PreparedStatement stmt = this.repo.getPreparedStatement(bareJid, this.ALLOCATE_SLOT_QUERY);
            ResultSet rs = null;
            PreparedStatement preparedStatement = stmt;
            synchronized (preparedStatement) {
                block7: {
                    FileUploadRepository.Slot slot;
                    try {
                        stmt.setString(1, slotId);
                        stmt.setString(2, bareJid.toString());
                        stmt.setString(3, bareJid.getDomain());
                        stmt.setString(4, sender.getResource());
                        stmt.setString(5, filename);
                        stmt.setLong(6, filesize);
                        stmt.setString(7, contentType);
                        rs = stmt.executeQuery();
                        if (!rs.next()) break block7;
                        rs.getString(1);
                        slot = new FileUploadRepository.Slot(bareJid, slotId, filename, filesize, contentType, new Date());
                    }
                    catch (Throwable throwable) {
                        this.repo.release(null, rs);
                        throw throwable;
                    }
                    this.repo.release(null, rs);
                    return slot;
                }
                this.repo.release(null, rs);
                return null;
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Could not allocate slot", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSlot(BareJID userJid, String slotId) throws TigaseDBException {
        try {
            PreparedStatement stmt = this.repo.getPreparedStatement(userJid, this.UPDATE_SLOT_QUERY);
            ResultSet rs = null;
            PreparedStatement preparedStatement = stmt;
            synchronized (preparedStatement) {
                try {
                    stmt.setString(1, slotId);
                    stmt.executeUpdate();
                }
                finally {
                    this.repo.release(null, rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Could not calculated used transfer", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileUploadRepository.Slot getSlot(BareJID sender, String slotId) throws TigaseDBException {
        try {
            PreparedStatement stmt = this.repo.getPreparedStatement(sender, this.GET_SLOT_QUERY);
            ResultSet rs = null;
            PreparedStatement preparedStatement = stmt;
            synchronized (preparedStatement) {
                try {
                    stmt.setString(1, slotId);
                    rs = stmt.executeQuery();
                    if (!rs.next()) return null;
                    BareJID jid = BareJID.bareJIDInstanceNS((String)rs.getString(1));
                    String filename = rs.getString(3);
                    long filesize = rs.getLong(4);
                    String contentType = rs.getString(5);
                    Timestamp ts = this.repo.getTimestamp(rs, 6);
                    FileUploadRepository.Slot slot = new FileUploadRepository.Slot(jid, slotId, filename, filesize, contentType, ts);
                    return slot;
                }
                finally {
                    this.repo.release(null, rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Could not allocate slot", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileUploadRepository.Slot> listExpiredSlots(BareJID domain, LocalDateTime before, int limit) throws TigaseDBException {
        ArrayList<FileUploadRepository.Slot> results = new ArrayList<FileUploadRepository.Slot>();
        try {
            PreparedStatement stmt = this.repo.getPreparedStatement(domain, this.LIST_EXPIRED_SLOTS_QUERY);
            ResultSet rs = null;
            PreparedStatement preparedStatement = stmt;
            synchronized (preparedStatement) {
                try {
                    stmt.setString(1, domain.getDomain());
                    this.repo.setTimestamp(stmt, 2, new Timestamp(before.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
                    stmt.setInt(3, limit);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        BareJID jid = BareJID.bareJIDInstanceNS((String)rs.getString(1));
                        String slotId = rs.getString(2);
                        String filename = rs.getString(3);
                        results.add(new FileUploadRepository.Slot(jid, slotId, filename, -1L, null, null));
                    }
                }
                catch (Throwable throwable) {
                    this.repo.release(null, rs);
                    throw throwable;
                }
                this.repo.release(null, rs);
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Could not allocate slot", (Throwable)ex);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExpiredSlots(BareJID domain, LocalDateTime before, int limit) throws TigaseDBException {
        try {
            PreparedStatement stmt = this.repo.getPreparedStatement(domain, this.REMOVE_EXPIRED_SLOTS_QUERY);
            ResultSet rs = null;
            PreparedStatement preparedStatement = stmt;
            synchronized (preparedStatement) {
                try {
                    stmt.setString(1, domain.getDomain());
                    this.repo.setTimestamp(stmt, 2, new Timestamp(before.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
                    stmt.setInt(3, limit);
                    stmt.execute();
                }
                finally {
                    this.repo.release(null, rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Could not allocate slot", (Throwable)ex);
        }
    }

    public void setDataSource(DataRepository dataSource) {
        try {
            dataSource.initPreparedStatement(this.ALLOCATE_SLOT_QUERY, this.ALLOCATE_SLOT_QUERY);
            dataSource.initPreparedStatement(this.UPDATE_SLOT_QUERY, this.UPDATE_SLOT_QUERY);
            dataSource.initPreparedStatement(this.GET_SLOT_QUERY, this.GET_SLOT_QUERY);
            dataSource.initPreparedStatement(this.LIST_EXPIRED_SLOTS_QUERY, this.LIST_EXPIRED_SLOTS_QUERY);
            dataSource.initPreparedStatement(this.REMOVE_EXPIRED_SLOTS_QUERY, this.REMOVE_EXPIRED_SLOTS_QUERY);
            this.repo = dataSource;
        }
        catch (SQLException ex) {
            throw new RuntimeException("Could not initialize repository", ex);
        }
    }
}

