/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.upload.store;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.http.upload.FileUploadComponent;
import tigase.http.upload.store.Store;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.xmpp.jid.BareJID;

@Bean(name="store", parent=FileUploadComponent.class, active=true, exportable=true)
public class DirectoryStore
implements Store {
    private static final Logger log = Logger.getLogger(DirectoryStore.class.getCanonicalName());
    @ConfigField(desc="Group user slots in directories", alias="group-by-user")
    private boolean groupByUser = false;
    @ConfigField(desc="Path for data storage", alias="path")
    private String path = "data/upload";
    private Path root = Paths.get(this.path, new String[0]);

    public void setPath(String path) {
        this.path = path;
        this.root = Paths.get(path, new String[0]);
    }

    @Override
    public long count() throws IOException {
        if (!this.groupByUser) {
            Throwable throwable = null;
            Object var2_5 = null;
            try (Stream<Path> stream = Files.list(this.root);){
                return stream.count();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        Throwable throwable = null;
        Object var2_7 = null;
        try (Stream<Path> stream = Files.list(this.root);){
            return stream.mapToLong(f -> {
                try {
                    Throwable throwable = null;
                    Object var2_3 = null;
                    try (Stream<Path> s = Files.list(f);){
                        return s.count();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    return 0L;
                }
            }).sum();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public long size() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> stream = Files.walk(this.root, new FileVisitOption[0]);){
            return stream.filter(f -> Files.isRegularFile(f, new LinkOption[0])).mapToLong(f -> {
                try {
                    return Files.size(f);
                }
                catch (IOException iOException) {
                    return 0L;
                }
            }).sum();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ReadableByteChannel getContent(BareJID uploader, String slotId, String filename) throws IOException {
        Path slot = this.prepareSlotPath(uploader, slotId);
        Path file = slot.resolve(filename);
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        return FileChannel.open(file, StandardOpenOption.READ);
    }

    @Override
    public void setContent(BareJID uploader, String slotId, String filename, long size, ReadableByteChannel source) throws IOException {
        Path slot = this.prepareSlotPath(uploader, slotId);
        Path file = slot.resolve(filename);
        Files.createDirectories(slot, new FileAttribute[0]);
        Throwable throwable = null;
        Object var10_10 = null;
        try (FileChannel destination = FileChannel.open(file, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            destination.transferFrom(source, 0L, size);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void remove(BareJID uploader, String slotId) {
        Path slot = this.prepareSlotPath(uploader, slotId);
        this.removeWithContent(slot);
    }

    protected Path prepareSlotPath(BareJID uploader, String slotId) {
        Path path = this.groupByUser ? this.root.resolve(uploader.toString()) : this.root;
        return path.resolve(slotId);
    }

    protected void removeWithContent(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Files.list(path).forEach(p1 -> this.removeWithContent((Path)p1));
                }
                Files.delete(path);
            }
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Could not remove " + path.toString(), ex);
        }
    }
}

