/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.rest;

import java.util.Queue;
import javax.script.Bindings;
import tigase.http.modules.rest.AbstractApiKeyCmd;
import tigase.http.modules.rest.ApiKeyItem;
import tigase.http.modules.rest.RestModule;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;

public class ApiKeyRemoveCmd
extends AbstractApiKeyCmd {
    private static final String ITEMS = "item-list";

    public ApiKeyRemoveCmd(RestModule module) {
        super(module);
    }

    public String getCommandId() {
        return "api-key-remove";
    }

    public String getDescription() {
        return "Remove API key";
    }

    public String getGroup() {
        return "Configuration";
    }

    public void runCommand(Iq packet, Bindings binds, Queue<Packet> results) {
        if (!this.checkIsFromAdmin(packet, results::offer)) {
            return;
        }
        String itemKey = Command.getFieldValue((Packet)packet, (String)ITEMS);
        if (itemKey == null) {
            String[] itemsStr = (String[])this.module.getApiKeyRepository().allItems().stream().map(ApiKeyItem::getKey).toArray(String[]::new);
            if (itemsStr.length > 0) {
                Iq result = (Iq)packet.commandResult(Command.DataType.form);
                Command.addFieldValue((Packet)result, (String)ITEMS, (String)itemsStr[0], (String)"List of items", (String[])itemsStr, (String[])itemsStr);
                results.offer((Packet)result);
            } else {
                Iq result = (Iq)packet.commandResult(Command.DataType.result);
                Command.addTextField((Packet)result, (String)"Note", (String)"There are no items on the list");
                results.offer((Packet)result);
            }
            return;
        }
        Iq result = (Iq)packet.commandResult(Command.DataType.result);
        ApiKeyItem item = (ApiKeyItem)this.module.getApiKeyRepository().getItem(itemKey);
        if (item == null) {
            Command.addTextField((Packet)result, (String)"Error", (String)"No such item, deletion impossible.");
        } else {
            this.module.getApiKeyRepository().removeItem(itemKey);
            Command.addTextField((Packet)result, (String)"Note", (String)"Operation successful");
        }
        results.add((Packet)result);
    }
}

