/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dnswebservice;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import tigase.http.modules.dnswebservice.DnsEntry;
import tigase.http.modules.dnswebservice.DnsItem;
import tigase.util.cache.SimpleCache;

public class DnsResolver {
    public static final Logger log = Logger.getLogger(DnsResolver.class.getName());
    private static final long DNS_CACHE_TIME = 60000L;
    private static Map<String, Future<DnsItem>> cache = Collections.synchronizedMap(new SimpleCache(500, 60000L));
    private static ExecutorService executor = Executors.newCachedThreadPool();

    private static List<DnsEntry> addressesToDnsEntries(InetAddress[] addrs, int port, int priority) {
        ArrayList<DnsEntry> entries = new ArrayList<DnsEntry>();
        HashMap<String, ArrayList<String>> hostnameToIps = new HashMap<String, ArrayList<String>>();
        InetAddress[] inetAddressArray = addrs;
        int n = addrs.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress addr = inetAddressArray[n2];
            try {
                InetAddress host = InetAddress.getByAddress(addr.getAddress());
                String hostname = host.getHostName();
                ArrayList<String> tmp = (ArrayList<String>)hostnameToIps.get(hostname);
                if (tmp == null) {
                    tmp = new ArrayList<String>();
                    hostnameToIps.put(hostname, tmp);
                }
                tmp.add(addr.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {}
            ++n2;
        }
        for (String host : hostnameToIps.keySet()) {
            List ipsList = (List)hostnameToIps.get(host);
            String[] ips = ipsList.toArray(new String[ipsList.size()]);
            DnsEntry entry = new DnsEntry(host, port, ips, priority);
            entries.add(entry);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DnsItem get(String domain) {
        try {
            Future<DnsItem> item = cache.get(domain);
            if (item != null) {
                return item.get();
            }
            ResolverTask resolver = new ResolverTask(domain);
            Map<String, Future<DnsItem>> map = cache;
            synchronized (map) {
                item = cache.get(domain);
                if (item == null) {
                    item = executor.submit(resolver);
                    cache.put(domain, item);
                }
            }
            return item.get();
        }
        catch (Exception exception) {
            cache.remove(domain);
            return null;
        }
    }

    public static void main(String[] argv) {
        DnsResolver.get("hi-low.eu");
    }

    private static DnsEntry parseSrvEntry(String str) throws UnknownHostException {
        String[] parts = str.split(" ");
        int priority = 0;
        int port = 5222;
        String host = parts[3];
        if (host.endsWith(".")) {
            host = host.substring(0, host.length() - 1);
        }
        try {
            priority = Integer.parseInt(parts[0]);
        }
        catch (Exception exception) {}
        try {
            Integer.parseInt(parts[1]);
        }
        catch (Exception exception) {}
        try {
            port = Integer.parseInt(parts[2]);
        }
        catch (Exception exception) {}
        InetAddress[] addrs = InetAddress.getAllByName(host);
        String[] ips = new String[addrs.length];
        int i = 0;
        while (i < addrs.length) {
            ips[i] = addrs[i].getHostAddress();
            ++i;
        }
        return new DnsEntry(host, port, ips, priority);
    }

    private static DnsItem resolve(String domain) {
        Context ctx = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>(5);
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            ctx = new InitialDirContext(env);
            DnsEntry[] c2sEntries = DnsResolver.resolveC2S((DirContext)ctx, domain);
            if (c2sEntries == null) {
                return null;
            }
            DnsEntry[] boshEntries = DnsResolver.resolveBosh((DirContext)ctx, domain, c2sEntries);
            DnsEntry[] websocketEntries = DnsResolver.resolveWebSocket((DirContext)ctx, domain, c2sEntries);
            DnsItem dnsItem = new DnsItem(domain, c2sEntries, boshEntries, websocketEntries);
            return dnsItem;
        }
        catch (Exception exception) {
            return null;
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ex) {
                    Logger.getLogger(DnsResolver.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private static DnsEntry[] resolveBosh(DirContext ctx, String domain, DnsEntry[] c2sEntries) {
        try {
            log.log(Level.FINE, "checking bosh for = _xmppconnect." + domain);
            Attributes attrs = ctx.getAttributes("_xmppconnect." + domain, new String[]{"TXT"});
            Attribute attr = attrs.get("TXT");
            if (attr != null && attr.size() > 0) {
                ArrayList<DnsEntry> entries2 = new ArrayList<DnsEntry>();
                int i = 0;
                while (i < attr.size()) {
                    String data = attr.get(i).toString();
                    if (data.startsWith("_xmpp-client-xbosh")) {
                        String uri = data.replace("_xmpp-client-xbosh=", "");
                        entries2.add(new DnsEntry(uri, 0));
                    }
                    ++i;
                }
                if (!entries2.isEmpty()) {
                    return entries2.toArray(new DnsEntry[entries2.size()]);
                }
            }
        }
        catch (NamingException namingException) {}
        if (c2sEntries != null) {
            int n;
            ArrayList<DnsEntry> entries = new ArrayList<DnsEntry>();
            DnsEntry[] dnsEntryArray = c2sEntries;
            int n2 = c2sEntries.length;
            int entries2 = 0;
            while (entries2 < n2) {
                DnsEntry c2sEntry = dnsEntryArray[entries2];
                DnsEntry[] tmp = DnsResolver.resolveBosh(ctx, c2sEntry.getHost(), null);
                if (tmp != null) {
                    DnsEntry[] dnsEntryArray2 = tmp;
                    n = tmp.length;
                    int n3 = 0;
                    while (n3 < n) {
                        DnsEntry entry = dnsEntryArray2[n3];
                        entries.add(entry);
                        ++n3;
                    }
                }
                ++entries2;
            }
            if (entries.isEmpty()) {
                HashSet<String> hostnames = new HashSet<String>();
                DnsEntry[] dnsEntryArray3 = c2sEntries;
                int n4 = c2sEntries.length;
                n2 = 0;
                while (n2 < n4) {
                    DnsEntry c2sEntry = dnsEntryArray3[n2];
                    try {
                        InetAddress[] addrs;
                        InetAddress[] inetAddressArray = addrs = InetAddress.getAllByName(c2sEntry.getHost());
                        int n5 = addrs.length;
                        n = 0;
                        while (n < n5) {
                            InetAddress addr = inetAddressArray[n];
                            try {
                                InetAddress tmp = InetAddress.getByAddress(addr.getAddress());
                                hostnames.add(tmp.getHostName());
                            }
                            catch (UnknownHostException unknownHostException) {}
                            ++n;
                        }
                    }
                    catch (UnknownHostException unknownHostException) {}
                    ++n2;
                }
                for (String hostname : hostnames) {
                    entries.add(new DnsEntry("http://" + hostname + ":5280/bosh", 0));
                }
            }
            if (!entries.isEmpty()) {
                return entries.toArray(new DnsEntry[entries.size()]);
            }
        }
        return null;
    }

    private static DnsEntry[] resolveC2S(DirContext ctx, String domain) {
        block8: {
            try {
                Attributes attrs = ctx.getAttributes("_xmpp-client._tcp." + domain, new String[]{"SRV"});
                Attribute attr = attrs.get("SRV");
                if (attr == null || attr.size() <= 0) break block8;
                ArrayList<DnsEntry> entries = new ArrayList<DnsEntry>();
                int i = 0;
                while (i < attr.size()) {
                    String str = attr.get(i).toString();
                    try {
                        DnsEntry entry = DnsResolver.parseSrvEntry(str);
                        entries.add(entry);
                    }
                    catch (UnknownHostException unknownHostException) {}
                    ++i;
                }
                return entries.toArray(new DnsEntry[entries.size()]);
            }
            catch (NamingException namingException) {}
        }
        try {
            InetAddress[] addrs = InetAddress.getAllByName(domain);
            String[] ips = new String[addrs.length];
            int i = 0;
            while (i < addrs.length) {
                ips[i] = addrs[i].getHostAddress();
                ++i;
            }
            return new DnsEntry[]{new DnsEntry(domain, 5222, ips, 0)};
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private static DnsEntry[] resolveWebSocket(DirContext ctx, String domain, DnsEntry[] c2sEntries) {
        try {
            Attributes attrs = ctx.getAttributes("_xmppconnect." + domain, new String[]{"TXT"});
            Attribute attr = attrs.get("TXT");
            if (attr != null && attr.size() > 0) {
                ArrayList<DnsEntry> entries = new ArrayList<DnsEntry>();
                int i = 0;
                while (i < attr.size()) {
                    String data = attr.get(i).toString();
                    if (data.startsWith("_xmpp-client-websocket")) {
                        String uri = data.replace("_xmpp-client-websocket=", "");
                        entries.add(new DnsEntry(uri, 0));
                    }
                    ++i;
                }
                if (!entries.isEmpty()) {
                    return entries.toArray(new DnsEntry[entries.size()]);
                }
            }
        }
        catch (NamingException namingException) {}
        if (c2sEntries != null) {
            ArrayList<DnsEntry> entries = new ArrayList<DnsEntry>();
            DnsEntry[] dnsEntryArray = c2sEntries;
            int n = c2sEntries.length;
            int n2 = 0;
            while (n2 < n) {
                DnsEntry c2sEntry = dnsEntryArray[n2];
                DnsEntry[] tmp = DnsResolver.resolveWebSocket(ctx, c2sEntry.getHost(), null);
                if (tmp != null) {
                    DnsEntry[] dnsEntryArray2 = tmp;
                    int n3 = tmp.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        DnsEntry entry = dnsEntryArray2[n4];
                        entries.add(entry);
                        ++n4;
                    }
                }
                ++n2;
            }
            if (!entries.isEmpty()) {
                return entries.toArray(new DnsEntry[entries.size()]);
            }
        }
        return null;
    }

    private static class ResolverTask
    implements Callable<DnsItem> {
        private final String domain;

        public ResolverTask(String domain) {
            this.domain = domain;
        }

        @Override
        public DnsItem call() throws Exception {
            return DnsResolver.resolve(this.domain);
        }
    }
}

