/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.upload.db;

import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import tigase.db.AbstractDataSourceAwareTestCase;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.TigaseDBException;
import tigase.http.upload.db.FileUploadRepository;
import tigase.xmpp.jid.JID;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class AbstractFileUploadRepositoryTest<DS extends DataSource>
extends AbstractDataSourceAwareTestCase<DS, FileUploadRepository> {
    protected static final String PROJECT_ID = "http-api";
    protected static final String VERSION = "2.0.0";
    private static String filename;
    private static long filesize;
    private static String slotId;
    private static LocalDateTime testStart;
    private static JID uploader;

    static {
        uploader = null;
    }

    @BeforeClass
    public static void setupFileUploadTest() {
        uploader = JID.jidInstanceNS((String)("ua-" + UUID.randomUUID()), (String)"test", (String)"tigase-1");
        slotId = UUID.randomUUID().toString();
        filename = "test1.jpg";
        filesize = 12345L;
        testStart = LocalDateTime.now();
    }

    @Test
    public void test_1_allocateSlot() throws TigaseDBException, InterruptedException {
        Thread.sleep(1000L);
        FileUploadRepository.Slot slot = ((FileUploadRepository)this.repo).allocateSlot(uploader, slotId, filename, filesize, null);
        Assert.assertNotNull((Object)slot);
    }

    @Test
    public void test_2_getSlot() throws TigaseDBException {
        FileUploadRepository.Slot slot = ((FileUploadRepository)this.repo).getSlot(uploader.getBareJID(), slotId);
        Assert.assertNotNull((Object)slot);
        Assert.assertEquals((Object)uploader.getBareJID(), (Object)slot.uploader);
        Assert.assertEquals((Object)filename, (Object)slot.filename);
        Assert.assertEquals((long)filesize, (long)slot.filesize);
        Assert.assertEquals((Object)slotId, (Object)slot.slotId);
    }

    @Test
    public void test_3_updateSlot() throws TigaseDBException {
        ((FileUploadRepository)this.repo).updateSlot(uploader.getBareJID(), slotId);
    }

    @Test
    public void test_4_listExpiredSlots() throws TigaseDBException, InterruptedException {
        Thread.sleep(1000L);
        List slots = ((FileUploadRepository)this.repo).listExpiredSlots(uploader.getBareJID(), LocalDateTime.now(), 10);
        Assert.assertEquals((long)1L, (long)slots.size());
    }

    @Test
    public void test_5_removeExpiredSlots() throws TigaseDBException {
        ((FileUploadRepository)this.repo).removeExpiredSlots(uploader.getBareJID(), LocalDateTime.now(), 10);
        List slots = ((FileUploadRepository)this.repo).listExpiredSlots(uploader.getBareJID(), LocalDateTime.now(), 10);
        Assert.assertEquals((long)0L, (long)slots.size());
    }

    protected Class<? extends DataSourceAware> getDataSourceAwareIfc() {
        return FileUploadRepository.class;
    }
}

