/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import groovy.transform.Generated;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import tigase.db.AuthRepositoryMDImpl;
import tigase.http.modules.AbstractBareModule;
import tigase.http.modules.setup.Setup;
import tigase.http.modules.setup.SetupModule;
import tigase.http.util.CSSHelper;

public class SetupServlet
extends HttpServlet
implements GroovyObject {
    private static final Logger log;
    private final TemplateEngine templateEngine;
    private final Map<String, Template> templates;
    private final Setup setup;
    private SetupModule setupModule;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public SetupServlet() {
        MetaClass metaClass;
        Setup setup;
        GStringTemplateEngine gStringTemplateEngine = new GStringTemplateEngine();
        this.templateEngine = gStringTemplateEngine;
        ConcurrentHashMap<String, Template> concurrentHashMap = new ConcurrentHashMap<String, Template>();
        this.templates = concurrentHashMap;
        this.setup = setup = new Setup();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void init() throws ServletException {
        SetupModule setupModule;
        super.init();
        ServletConfig cfg = super.getServletConfig();
        String moduleUUID = cfg.getInitParameter("module");
        this.setupModule = setupModule = (SetupModule)ScriptBytecodeAdapter.castToType(AbstractBareModule.getModuleByUUID(moduleUUID), SetupModule.class);
        this.loadTemplates();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "exception processing request", ex);
            response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
        }
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Reference request2 = new Reference((Object)request);
        if (!((HttpServletRequest)request2.get()).isUserInRole("admin") && !((HttpServletRequest)request2.get()).authenticate(response)) {
            return;
        }
        this.loadTemplates();
        Template t = null;
        Reference templateParams = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"request", (HttpServletRequest)request2.get(), "response", response, "servlet", this}), LinkedHashMap.class)));
        if (this.setupModule.getAuthRepository() == null || this.setupModule.getAuthRepository() instanceof AuthRepositoryMDImpl && !DefaultTypeTransformation.booleanUnbox((Object)((AuthRepositoryMDImpl)ScriptBytecodeAdapter.castToType((Object)this.setupModule.getAuthRepository(), AuthRepositoryMDImpl.class)).getRepo(null))) {
            Setup setup = this.setup;
            DefaultGroovyMethods.putAt((Map)((LinkedHashMap)templateParams.get()), (Object)"setup", (Object)setup);
            String step = ((HttpServletRequest)request2.get()).getParameter("step");
            int i = 1;
            if (step != null) {
                int n;
                i = n = Integer.parseInt(step);
            }
            Template template = this.templates.get(StringGroovyMethods.plus((CharSequence)"step", (Object)i));
            t = (Template)ScriptBytecodeAdapter.castToType((Object)template, Template.class);
            if (i > 1 && "POST".equals(((HttpServletRequest)request2.get()).getMethod())) {
                Setup.Page page = this.setup.getPage(i - 1);
                page.setValues(((HttpServletRequest)request2.get()).getParameterMap());
            }
            Setup.Page page = this.setup.getPage(i);
            page.beforeDisplay();
            ((LinkedHashMap)templateParams.get()).put("page", page);
            ((LinkedHashMap)templateParams.get()).put("currentStep", i);
        } else {
            Template template = this.templates.get("edit");
            t = (Template)ScriptBytecodeAdapter.castToType((Object)template, Template.class);
            ((LinkedHashMap)templateParams.get()).put("currentStep", "edit");
        }
        public final class _processRequest_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference request;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processRequest_closure1(Object _outerInstance, Object _thisObject, Reference request) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.request = reference = request;
            }

            public Object doCall(String url) {
                if (DefaultTypeTransformation.booleanUnbox((Object)((ServletRequest)this.request.get()).getParameter("api-key"))) {
                    return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)((HttpServletRequest)this.request.get()).getContextPath(), (CharSequence)url), (CharSequence)(url.contains("?") ? "&" : "?")), (CharSequence)"api-key="), (CharSequence)((ServletRequest)this.request.get()).getParameter("api-key"));
                }
                return StringGroovyMethods.plus((String)((HttpServletRequest)this.request.get()).getContextPath(), (CharSequence)url);
            }

            public Object call(String url) {
                return this.doCall(url);
            }

            public HttpServletRequest getRequest() {
                return (HttpServletRequest)ScriptBytecodeAdapter.castToType((Object)this.request.get(), HttpServletRequest.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processRequest_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _processRequest_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference templateParams;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processRequest_closure2(Object _outerInstance, Object _thisObject, Reference templateParams) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.templateParams = reference = templateParams;
            }

            public Object doCall(String name, Map params) {
                Template temp = (Template)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(((SetupServlet)((Object)this.getThisObject())).templates, (Object)name), Template.class);
                if (temp == null) {
                    return "";
                }
                LinkedHashMap map = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
                map.putAll((Map)ScriptBytecodeAdapter.castToType((Object)this.templateParams.get(), Map.class));
                if (params != null) {
                    map.putAll(params);
                }
                return temp.make((Map)map);
            }

            public Object call(String name, Map params) {
                return this.doCall(name, params);
            }

            public Map getTemplateParams() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.templateParams.get(), Map.class);
            }

            public Object doCall(String name) {
                return this.doCall(name, null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processRequest_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _processRequest_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processRequest_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String path) {
                String content = CSSHelper.getCssFileContent(path);
                if (content == null) {
                    return "";
                }
                return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"<style>", (CharSequence)content), (CharSequence)"</style>");
            }

            public Object call(String path) {
                return this.doCall(path);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processRequest_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((LinkedHashMap)templateParams.get()).put("util", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"link", new _processRequest_closure1((Object)this, (Object)this, request2), "include", new _processRequest_closure2((Object)this, (Object)this, templateParams), "inlineCss", new _processRequest_closure3((Object)this, (Object)this)}));
        Writable w = t.make((Map)((LinkedHashMap)templateParams.get()));
        w.writeTo((Writer)response.getWriter());
    }

    private void loadTemplates() {
        int i = 1;
        boolean loaded = true;
        while (loaded) {
            try {
                String templateSrc = this.load("step", i, "html");
                Template template = this.templateEngine.createTemplate(templateSrc);
                this.templates.put(StringGroovyMethods.plus((CharSequence)"step", (Object)i), template);
                log.log(Level.FINEST, StringGroovyMethods.plus((CharSequence)"loaded html template for step ", (Object)i));
            }
            catch (Exception ex) {
                boolean bl;
                if (ex instanceof IOException && "Resource not found".equals(ex.getMessage())) {
                    log.log(Level.FINEST, StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"loaded ", (Object)(i - 1)), (CharSequence)" resource files."));
                } else {
                    log.log(Level.FINEST, StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"resource file for index = ", (Object)i), (CharSequence)" was not found and could not be loaded"), ex);
                }
                loaded = bl = false;
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        public final class _loadTemplates_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadTemplates_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String file) {
                String templateSrc = ((SetupServlet)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), SetupServlet.class))).load(file, null, "html");
                Template template = ((SetupServlet)((Object)this.getThisObject())).templateEngine.createTemplate(templateSrc);
                Template template2 = ((SetupServlet)((Object)this.getThisObject())).templates.put(file, template);
                try {
                    return template2;
                }
                catch (Exception ex) {
                    log.log(Level.FINEST, StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"resource ", (CharSequence)file), (CharSequence)" was not found and could not be loaded"), ex);
                    Object var6_6 = null;
                    return var6_6;
                }
            }

            public Object call(String file) {
                return this.doCall(file);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadTemplates_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)ScriptBytecodeAdapter.createList((Object[])new Object[]{"header", "footer", "index", "edit"}), (Closure)new _loadTemplates_closure4((Object)this, (Object)this));
    }

    private String load(String prefix, Integer i, String suffix) throws IOException {
        String path = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"tigase/setup/", (CharSequence)prefix), (CharSequence)(i == null ? "" : StringGroovyMethods.plus((CharSequence)"-", (Object)i))), (CharSequence)"."), (CharSequence)suffix);
        File f = new File(path);
        InputStream is = null;
        if (f.exists()) {
            FileInputStream fileInputStream = new FileInputStream(new File(path));
            is = fileInputStream;
        } else {
            InputStream inputStream;
            is = inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(StringGroovyMethods.plus((String)"/", (CharSequence)path));
        }
        if (is == null) {
            throw (Throwable)new IOException("Resource not found");
        }
        char[] buf = new char[1024];
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader r = new InputStreamReader(is);){
            int read = 0;
            while (true) {
                int n;
                read = n = r.read(buf);
                if (ScriptBytecodeAdapter.compareGreaterThan((Object)n, (Object)-1)) {
                    sb.append(buf, 0, read);
                    continue;
                }
                break;
            }
        }
        return sb.toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != SetupServlet.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = Logger.getLogger(SetupServlet.class.getCanonicalName());
    }
}

