/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.db.util.SchemaLoader;
import tigase.db.util.SchemaManager;
import tigase.http.modules.setup.Config;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.server.BasicComponent;
import tigase.server.xmppsession.SessionManager;
import tigase.util.setup.BeanDefinition;
import tigase.util.setup.SetupHelper;
import tigase.xmpp.XMPPImplIfc;
import tigase.xmpp.jid.BareJID;

public class Setup {
    private final Config config = new Config();
    private final List<Page> pages = new ArrayList<Page>();

    public Setup() {
        this.pages.add(new Page("About software", new Question[0]));
        Question[] questionArray = new Question[1];
        questionArray[0] = new SingleAnswerQuestion("acsName", this.config::getAcsName, this.config::setAcsName);
        this.pages.add(new Page("Advanced Clustering Strategy information", questionArray));
        this.pages.add(new Page("Basic Tigase server configuration", new SingleAnswerQuestion("configType", () -> this.config.getConfigType().id(), type -> this.config.setConfigType(ConfigTypeEnum.valueForId((String)type))), new VirtualDomainQuestion("virtualDomain", this.config), new AdminsQuestion("admins", this.config), new SingleAnswerQuestion("adminPwd", () -> this.config.adminPwd, pwd -> {
            String string = this.config.adminPwd = pwd;
        }), new SingleAnswerQuestion("dbType", () -> this.config.getDbType(), type -> this.config.setDbType((String)type)), new SingleAnswerQuestion("advancedConfig", () -> String.valueOf(this.config.advancedConfig), val -> {
            boolean bl = this.config.advancedConfig = val != null ? Boolean.parseBoolean(val) || "on".equals(val) : false;
        })));
        this.pages.add(new AdvConfigPage("Advanced configuration options", this.config, Stream.of(new SingleAnswerQuestion("clusterMode", () -> String.valueOf(this.config.getClusterMode()), val -> this.config.setClusterMode(val != null ? Boolean.parseBoolean(val) || "on".equals(val) : false)), new SingleAnswerQuestion("acsComponent", () -> String.valueOf(this.config.getACS()), val -> this.config.setACS(val != null ? Boolean.parseBoolean(val) || "on".equals(val) : false)))));
        this.pages.add(new PluginsConfigPage("Plugins selection", this.config));
        this.pages.add(new DBSetupPage("Database configuration"));
        this.pages.add(new DBCheckPage("Database connectivity check", new Question[0]));
        this.pages.add(new Page("Setup security", new SingleAnswerQuestion("setupUser", () -> this.config.httpSecurity.setupUser, user -> {
            String string = this.config.httpSecurity.setupUser = user;
        }), new SingleAnswerQuestion("setupPassword", () -> this.config.httpSecurity.setupPassword, pass -> {
            String string = this.config.httpSecurity.setupPassword = pass;
        })));
        this.pages.add(new Page("Saving configuration", new SingleAnswerQuestion("saveConfig", () -> "true", val -> {
            if (val != null && (Boolean.parseBoolean(val) || "on".equals(val))) {
                try {
                    this.config.saveConfig();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        })));
        this.pages.add(new Page("Finished", new Question[0]));
    }

    public Page getPage(int page) {
        return this.pages.get(page - 1);
    }

    private class AdminsQuestion
    extends SingleAnswerQuestion {
        AdminsQuestion(String id, Config config) {
            super(id, () -> Arrays.stream(config.admins).map(jid -> jid.toString()).collect(Collectors.joining(",")), (String admins) -> {
                config.admins = admins != null && !admins.trim().isEmpty() ? (BareJID[])Stream.of(admins.split(",")).map(str -> str.trim()).map(str -> BareJID.bareJIDInstanceNS((String)str)).toArray(BareJID[]::new) : new BareJID[0];
            });
        }
    }

    private class AdvConfigPage
    extends Page {
        private List<ComponentQuestion> optionalComponents;

        public AdvConfigPage(String title, Config config, Stream<Question> questions) {
            super(title, questions);
            this.optionalComponents = new ArrayList<ComponentQuestion>();
            this.optionalComponents = SetupHelper.getAvailableComponents().stream().filter(def -> !def.isCoreComponent()).map(def -> new ComponentQuestion((BeanDefinition)def, config)).sorted(ComponentQuestion.byBeanName).collect(Collectors.toList());
            this.optionalComponents.forEach(this::addQuestion);
        }

        public List<Question> getOptionalComponents() {
            return Collections.unmodifiableList(this.optionalComponents);
        }

        @Override
        protected void setValues(Map<String, String[]> params) {
            super.setValues(params);
            if (Setup.this.config.getClusterMode() && (((Setup)Setup.this).config.optionalComponents.contains("muc") || ((Setup)Setup.this).config.optionalComponents.contains("pubsub"))) {
                Setup.this.config.setACS(true);
            }
        }
    }

    private static class ComponentQuestion
    extends SingleAnswerQuestion {
        private static final Comparator<ComponentQuestion> byBeanName = (e1, e2) -> e1.getBeanName().compareTo(e2.getBeanName());
        private final BeanDefinition def;

        ComponentQuestion(BeanDefinition def, Config config) {
            super(def.getName(), () -> config.optionalComponents.contains(def.getName()) ? def.getName() : null, val -> {
                if (val != null && (Boolean.parseBoolean(val) || "on".equals(val))) {
                    config.optionalComponents.add(def.getName());
                } else {
                    config.optionalComponents.remove(def.getName());
                }
            });
            this.def = def;
        }

        @Override
        public String getLabel() {
            String desc = this.def.getName();
            try {
                desc = ((BasicComponent)this.def.getClazz().newInstance()).getDiscoDescription();
            }
            catch (Exception exception) {}
            return desc;
        }

        public String getBeanName() {
            return this.def.getName();
        }
    }

    private class DBCheckPage
    extends Page {
        public DBCheckPage(String title, Stream<Question> questions) {
            super(title, questions);
        }

        public DBCheckPage(String title, Question ... questions) {
            super(title, questions);
        }

        public synchronized Map<SchemaManager.DataSourceInfo, List<SchemaManager.ResultEntry>> loadSchema() {
            try {
                Map<String, Object> configStr = Setup.this.config.getConfigurationInMap();
                SchemaManager schemaManager = new SchemaManager();
                schemaManager.setConfig(configStr);
                schemaManager.setDbRootCredentials(((Setup)Setup.this).config.dbProperties.getProperty("rootUser"), ((Setup)Setup.this).config.dbProperties.getProperty("rootPass"));
                if (((Setup)Setup.this).config.admins != null) {
                    schemaManager.setAdmins(Arrays.asList(((Setup)Setup.this).config.admins), ((Setup)Setup.this).config.adminPwd);
                }
                return schemaManager.loadSchemas();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class DBSetupPage
    extends Page {
        private List<Question> questions;

        public DBSetupPage(String title) {
            super(title, new Question[0]);
            this.questions = new ArrayList<Question>();
        }

        @Override
        public void beforeDisplay() {
            List options = SchemaLoader.newInstance((String)Setup.this.config.getDbType()).getSetupOptions();
            Stream<Question> questions = options.stream().map(o -> {
                SingleAnswerQuestion question = null;
                if (Boolean.class.equals((Object)o.getType())) {
                    question = new SingleAnswerQuestion((String)o.getFullName().get(), (String)o.getDescription().get(), () -> {
                        String val = ((Setup)Setup.this).config.dbProperties.getProperty((String)o.getFullName().get());
                        if (val == null) {
                            val = o.getDefaultValue().orElse(null);
                        }
                        return val;
                    }, val -> {
                        boolean bval = val != null ? Boolean.parseBoolean(val) || "on".equals(val) : false;
                        ((Setup)Setup.this).config.dbProperties.setProperty((String)o.getFullName().get(), String.valueOf(bval));
                    });
                } else {
                    question = new SingleAnswerQuestion((String)o.getFullName().get(), (String)o.getDescription().get(), () -> {
                        String val = ((Setup)Setup.this).config.dbProperties.getProperty((String)o.getFullName().get());
                        if (val == null) {
                            val = o.getDefaultValue().orElse(null);
                        }
                        return val;
                    }, val -> {
                        if (val == null || val.trim().isEmpty()) {
                            ((Setup)Setup.this).config.dbProperties.remove(o.getFullName().get());
                        } else {
                            ((Setup)Setup.this).config.dbProperties.setProperty((String)o.getFullName().get(), (String)val);
                        }
                    });
                    question.setSecret(o.isSecret());
                }
                return question;
            });
            this.questions.clear();
            this.setQuestions(questions);
        }

        public List<Question> getQuestions() {
            return this.questions;
        }

        @Override
        protected void addQuestion(Question question) {
            super.addQuestion(question);
            this.questions.add(question);
        }
    }

    public static class MultiAnswerQuestion
    extends Question {
        private final Supplier<String[]> getter;
        private final Consumer<String[]> setter;

        public MultiAnswerQuestion(String id, Supplier<String[]> getter, Consumer<String[]> setter) {
            super(id);
            this.getter = getter;
            this.setter = setter;
        }

        public String[] getValues() {
            return this.getter.get();
        }

        @Override
        public void setValues(String[] value) {
            this.setter.accept(value);
        }
    }

    public class Page {
        private final Map<String, Question> questions = new ConcurrentHashMap<String, Question>();
        private final String title;

        public Page(String title, Stream<Question> questions) {
            this.title = title;
            this.setQuestions(questions);
        }

        public Page(String title, Question ... questions) {
            this(title, Arrays.stream(questions));
        }

        public String getId() {
            return "" + Setup.this.pages.indexOf(this);
        }

        public String getTitle() {
            return this.title;
        }

        public Question getQuestion(String id) {
            return this.questions.get(id);
        }

        public void beforeDisplay() {
        }

        public Integer nextPage() {
            int i = Setup.this.pages.indexOf(this);
            return i + 1 + 1;
        }

        protected void addQuestion(Question question) {
            question.setPage(this);
            this.questions.put(question.getId(), question);
        }

        protected void setQuestions(Stream<Question> questions) {
            this.questions.clear();
            questions.forEach(this::addQuestion);
        }

        protected void setValues(Map<String, String[]> params) {
            this.questions.values().forEach(question -> {
                String[] value = (String[])params.get(question.getName());
                question.setValues(value);
            });
        }
    }

    private static class PluginQuestion
    extends SingleAnswerQuestion {
        private static final Comparator<PluginQuestion> byBeanName = (e1, e2) -> e1.getBeanName().compareTo(e2.getBeanName());
        private final Config config;
        private final BeanDefinition def;

        PluginQuestion(BeanDefinition def, Config config) {
            super(def.getName(), () -> config.plugins.contains(def.getName()) ? def.getName() : null, val -> {
                if (val != null && (Boolean.parseBoolean(val) || "on".equals(val))) {
                    config.plugins.add(def.getName());
                } else {
                    config.plugins.remove(def.getName());
                }
            });
            this.def = def;
            this.config = config;
        }

        @Override
        public String getLabel() {
            return null;
        }

        public String getBeanName() {
            return this.def.getName();
        }

        public boolean mayBeChanged() {
            if (!this.mayBeEnabled()) {
                return false;
            }
            return !this.def.getClazz().getCanonicalName().equals("tigase.archive.unified.processors.UnifiedArchivePlugin") || !this.config.optionalComponents.contains("unified-archive");
        }

        public boolean mayBeEnabled() {
            if (this.def.getClazz().getCanonicalName().startsWith("tigase.archive.unified")) {
                return this.config.optionalComponents.contains("unified-archive");
            }
            if (this.def.getClazz().getCanonicalName().startsWith("tigase.archive.")) {
                return this.config.optionalComponents.contains("message-archive") || this.config.optionalComponents.contains("unified-archive");
            }
            if (this.def.getClazz().getCanonicalName().startsWith("tigase.pubsub.")) {
                return this.config.optionalComponents.contains("pubsub");
            }
            return true;
        }

        public String getCause() {
            if (this.def.getClazz().getCanonicalName().startsWith("tigase.archive.unified")) {
                return "Processor requires Tigase Unified Archive Component";
            }
            if (this.def.getClazz().getCanonicalName().startsWith("tigase.archive.")) {
                return "Processor requires Tigase Message Archiving Component or Tigase Unified Component";
            }
            if (this.def.getClazz().getCanonicalName().startsWith("tigase.pubsub.")) {
                return "Processor requires Tigase PubSub Component";
            }
            return null;
        }

        @Override
        public boolean isSelected(String value) {
            if (this.def.getClazz().getCanonicalName().equals("tigase.archive.unified.processors.UnifiedArchivePlugin")) {
                return this.config.optionalComponents.contains("unified-archive");
            }
            return super.isSelected(value);
        }
    }

    private class PluginsConfigPage
    extends Page {
        private List<PluginQuestion> plugins;

        PluginsConfigPage(String title, Config config) {
            super(title, Stream.empty());
            this.plugins = SetupHelper.getAvailableProcessors(SessionManager.class, XMPPImplIfc.class).stream().map(def -> new PluginQuestion((BeanDefinition)def, config)).sorted(PluginQuestion.byBeanName).collect(Collectors.toList());
            this.plugins.forEach(this::addQuestion);
        }

        public List<Question> getPlugins() {
            return Collections.unmodifiableList(this.plugins);
        }
    }

    public static abstract class Question {
        private final String id;
        private Page page;
        private boolean secret = false;

        public Question(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return String.valueOf(this.page.getId()) + "_" + this.getId();
        }

        public boolean isSecret() {
            return this.secret;
        }

        protected void setSecret(boolean secret) {
            this.secret = secret;
        }

        protected void setPage(Page page) {
            this.page = page;
        }

        protected abstract void setValues(String[] var1);
    }

    public static class SingleAnswerQuestion
    extends Question {
        private final Supplier<String> getter;
        private final String label;
        private final Consumer<String> setter;

        public SingleAnswerQuestion(String id, Supplier<String> getter, Consumer<String> setter) {
            this(id, null, getter, setter);
        }

        public SingleAnswerQuestion(String id, String label, Supplier<String> getter, Consumer<String> setter) {
            super(id);
            this.label = label;
            this.getter = getter;
            this.setter = setter;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.getter.get();
        }

        public void setValue(String value) {
            this.setter.accept(value);
        }

        public boolean isSelected(String value) {
            return value != null && value.equals(this.getValue());
        }

        @Override
        protected void setValues(String[] values) {
            this.setValue(values == null || values.length == 0 ? null : (values[0].trim().isEmpty() ? null : values[0]));
        }
    }

    private class VirtualDomainQuestion
    extends SingleAnswerQuestion {
        VirtualDomainQuestion(String id, Config config) {
            super(id, () -> Optional.ofNullable(config.defaultVirtualDomain).orElse(""), (String vhost) -> {
                config.defaultVirtualDomain = vhost;
            });
        }
    }
}

