/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.java;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class DummyServletResponse
implements HttpServletResponse {
    private final HttpExchange exchange;
    private PrintWriter writer;

    public DummyServletResponse(HttpExchange exchange) {
        this.exchange = exchange;
    }

    public String getCharacterEncoding() {
        return "UTF-8";
    }

    public void setCharacterEncoding(String string) {
    }

    public String getContentType() {
        return null;
    }

    public void setContentType(String string) {
        this.exchange.getResponseHeaders().set("Content-Type", string);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            public void write(int b) throws IOException {
                if (DummyServletResponse.this.exchange.getResponseCode() == -1) {
                    DummyServletResponse.this.sendResponseHeaders(200, 0);
                }
                DummyServletResponse.this.exchange.getResponseBody().write(b);
            }

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener wl) {
            }
        };
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            if (this.exchange.getResponseCode() == -1) {
                this.sendResponseHeaders(200, 0);
            }
            this.writer = new PrintWriter(this.exchange.getResponseBody());
        }
        return this.writer;
    }

    public void setContentLength(int i) {
        this.exchange.getResponseHeaders().set("Content-Length", String.valueOf(i));
    }

    public int getBufferSize() {
        return 0;
    }

    public void setBufferSize(int i) {
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.exchange.getResponseBody().flush();
    }

    public void resetBuffer() {
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public Locale getLocale() {
        return null;
    }

    public void setLocale(Locale locale) {
    }

    public void addCookie(Cookie cookie) {
    }

    public boolean containsHeader(String string) {
        return false;
    }

    public String encodeURL(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DummyServletResponse.class.getName()).log(Level.FINE, "could not URLEncode string: " + string, ex);
            return null;
        }
    }

    public String encodeRedirectURL(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DummyServletResponse.class.getName()).log(Level.FINE, "could not URLEncode string: " + string, ex);
            return null;
        }
    }

    public String encodeUrl(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DummyServletResponse.class.getName()).log(Level.FINE, "could not URLEncode string: " + string, ex);
            return null;
        }
    }

    public String encodeRedirectUrl(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DummyServletResponse.class.getName()).log(Level.FINE, "could not URLEncode string: " + string, ex);
            return null;
        }
    }

    public void sendError(int i, String string) throws IOException {
        if (string != null && !"HEAD".equals(this.exchange.getRequestMethod())) {
            this.sendResponseHeaders(i, string.getBytes().length);
            PrintWriter writer = this.getWriter();
            writer.write(string);
            writer.flush();
        } else {
            this.sendResponseHeaders(i, 0);
        }
    }

    public void sendError(int i) throws IOException {
        this.sendResponseHeaders(i, 0);
    }

    public void sendRedirect(String string) throws IOException {
        this.exchange.getResponseHeaders().set("Location", string);
        this.sendResponseHeaders(302, 0);
    }

    public void setDateHeader(String string, long l) {
    }

    public void addDateHeader(String string, long l) {
    }

    public void setHeader(String string, String string1) {
        this.exchange.getResponseHeaders().set(string, string1);
    }

    public void addHeader(String string, String string1) {
        this.exchange.getResponseHeaders().add(string, string1);
    }

    public void setIntHeader(String string, int i) {
    }

    public void addIntHeader(String string, int i) {
    }

    public void setStatus(int i, String string) {
        try {
            this.sendResponseHeaders(i, 0);
        }
        catch (IOException ex) {
            Logger.getLogger(DummyServletResponse.class.getName()).log(Level.FINE, null, ex);
        }
    }

    public int getStatus() {
        return 200;
    }

    public void setStatus(int i) {
        try {
            this.sendResponseHeaders(i, 0);
        }
        catch (IOException ex) {
            Logger.getLogger(DummyServletResponse.class.getName()).log(Level.FINE, null, ex);
        }
    }

    public String getHeader(String string) {
        return this.exchange.getResponseHeaders().getFirst(string);
    }

    public Collection<String> getHeaders(String string) {
        return null;
    }

    public Collection<String> getHeaderNames() {
        return null;
    }

    public void setContentLengthLong(long l) {
        this.setHeader("Content-Length", String.valueOf(l));
    }

    private void sendResponseHeaders(int rCode, int contentLength) throws IOException {
        if ("HEAD".equals(this.exchange.getRequestMethod())) {
            this.exchange.sendResponseHeaders(rCode, -1L);
        } else {
            this.exchange.sendResponseHeaders(rCode, contentLength);
        }
    }
}

