/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.java;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import tigase.http.DeploymentInfo;
import tigase.http.api.HttpServerIfc;
import tigase.http.java.RequestHandler;
import tigase.io.TLSUtil;
import tigase.net.SocketType;

public class JavaStandaloneHttpServer
implements HttpServerIfc {
    private static final Logger log = Logger.getLogger(JavaStandaloneHttpServer.class.getCanonicalName());
    private final Set<HttpServer> servers = new HashSet<HttpServer>();
    private int[] ports = new int[]{8080};
    private final Map<String, Map<String, Object>> portsConfigs = new HashMap<String, Map<String, Object>>();
    private List<DeploymentInfo> deployments = new ArrayList<DeploymentInfo>();
    private ExecutorWithTimeout executor = new ExecutorWithTimeout();
    private Timer timer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Set<HttpServer> set = this.servers;
        synchronized (set) {
            if (!this.servers.isEmpty()) {
                this.stop();
            }
            this.timer = new Timer();
            this.executor.start();
            int[] nArray = this.ports;
            int n = this.ports.length;
            int n2 = 0;
            while (n2 < n) {
                int port = nArray[n2];
                try {
                    HttpServer server = this.createServer(port);
                    server.setExecutor(this.executor);
                    server.start();
                    this.deploy(server, Collections.unmodifiableList(this.deployments));
                    this.servers.add(server);
                }
                catch (IOException ex) {
                    log.log(Level.SEVERE, "starting server on port " + port + " failed", ex);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Set<HttpServer> set = this.servers;
        synchronized (set) {
            for (HttpServer server : this.servers) {
                this.undeploy(server, Collections.unmodifiableList(this.deployments));
                server.stop(1);
            }
            this.servers.clear();
            this.executor.shutdown();
            this.timer.cancel();
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(DeploymentInfo deployment) {
        this.deployments.add(deployment);
        Set<HttpServer> set = this.servers;
        synchronized (set) {
            for (HttpServer server : this.servers) {
                this.deploy(server, Collections.singletonList(deployment));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(DeploymentInfo deployment) {
        this.deployments.remove(deployment);
        Set<HttpServer> set = this.servers;
        synchronized (set) {
            for (HttpServer server : this.servers) {
                this.undeploy(server, Collections.singletonList(deployment));
            }
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        if (props.containsKey("port")) {
            this.ports = new int[]{(Integer)props.get("port")};
        }
        if (props.containsKey("ports")) {
            this.ports = (int[])props.get("ports");
        }
        this.portsConfigs.clear();
        int[] nArray = this.ports;
        int n = this.ports.length;
        int n2 = 0;
        while (n2 < n) {
            int port = nArray[n2];
            HashMap<String, Object> config = new HashMap<String, Object>();
            String socket = (String)props.get(String.valueOf(String.valueOf(port)) + "/" + "socket");
            config.put("socket", socket != null ? SocketType.valueOf((String)socket) : SocketType.plain);
            String domain = (String)props.get(String.valueOf(String.valueOf(port)) + "/" + "domain");
            config.put("domain", domain);
            this.portsConfigs.put(String.valueOf(port), config);
            ++n2;
        }
        this.executor.setProperties(props);
    }

    private HttpServer createServer(int port) throws IOException {
        Map<String, Object> config = this.portsConfigs.get(String.valueOf(port));
        if (config == null || (SocketType)config.get("socket") == SocketType.plain) {
            return HttpServer.create(new InetSocketAddress(port), 100);
        }
        HttpsServer server = HttpsServer.create(new InetSocketAddress(port), 100);
        String domain = (String)config.get("domain");
        SSLContext sslContext = TLSUtil.getSSLContext((String)"TLS", (String)domain);
        server.setHttpsConfigurator(new HttpsConfigurator(sslContext));
        return server;
    }

    private void deploy(HttpServer server, List<DeploymentInfo> toDeploy) {
        for (DeploymentInfo info : toDeploy) {
            server.createContext(info.getContextPath(), new RequestHandler(info, this.timer));
        }
    }

    private void undeploy(HttpServer server, List<DeploymentInfo> toUndeploy) {
        for (DeploymentInfo info : toUndeploy) {
            try {
                server.removeContext(info.getContextPath());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.log(Level.FINEST, "deployment context " + info.getContextPath() + " already removed");
            }
        }
    }

    private class ExecutorWithTimeout
    implements Executor {
        private static final String THREADS_KEY = "threads";
        private static final String REQUEST_TIMEOUT_KEY = "request-timeout";
        private ExecutorService executor = null;
        private int timeout = 60000;
        private int threads = 4;
        private AtomicInteger counter = new AtomicInteger(0);

        @Override
        public void execute(Runnable command) {
            this.executor.execute(() -> {
                RequestHandler.setExecutionTimeout(this.timeout);
                command.run();
            });
        }

        public void start() {
            if (this.executor != null) {
                this.shutdown();
            }
            this.executor = Executors.newFixedThreadPool(this.threads, r -> {
                Thread t = new Thread(r);
                t.setName("http-server-pool-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                return t;
            });
        }

        public void shutdown() {
            this.executor.shutdown();
        }

        public void setProperties(Map<String, Object> props) {
            if (props.containsKey(THREADS_KEY)) {
                this.threads = (Integer)props.get(THREADS_KEY);
            }
            if (props.containsKey(REQUEST_TIMEOUT_KEY)) {
                this.timeout = (Integer)props.get(REQUEST_TIMEOUT_KEY);
            }
        }
    }
}

