/*
 * Decompiled with CFR 0.152.
 */
package tigase.http;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import tigase.conf.ConfigurationException;
import tigase.http.DeploymentInfo;
import tigase.http.ServletInfo;
import tigase.http.api.HttpServerIfc;
import tigase.http.java.JavaStandaloneHttpServer;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.XMPPServer;

public class HttpServer {
    private static final Logger log = Logger.getLogger(HttpServer.class.getCanonicalName());
    private static final String DEF_HTTP_SERVER_CLASS_VAL = JavaStandaloneHttpServer.class.getCanonicalName();
    private static final String HTTP_SERVER_CLASS_KEY = "server-class";
    private CopyOnWriteArrayList<DeploymentInfo> deployed = new CopyOnWriteArrayList();
    private String serverClass = DEF_HTTP_SERVER_CLASS_VAL;
    private HttpServerIfc server = null;

    public Map<String, Object> getDefaults() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(HTTP_SERVER_CLASS_KEY, DEF_HTTP_SERVER_CLASS_VAL);
        return props;
    }

    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        if (props.containsKey(HTTP_SERVER_CLASS_KEY)) {
            this.serverClass = (String)props.get(HTTP_SERVER_CLASS_KEY);
        }
        try {
            if (!(this.serverClass == null || this.server != null && this.serverClass.equals(this.server.getClass().getCanonicalName()))) {
                if (this.server != null) {
                    this.server.stop();
                }
                Class cls = ModulesManagerImpl.getInstance().forName(this.serverClass);
                this.server = (HttpServerIfc)cls.newInstance();
            }
            this.server.setProperties(props);
        }
        catch (Exception e) {
            if (!XMPPServer.isOSGi()) {
                log.log(Level.SEVERE, "Cannot instantiate HTTP server implementation class: " + this.serverClass, e);
            }
            throw new ConfigurationException("Can not instantiate HTTP server implementation class: " + this.serverClass);
        }
    }

    public void start() {
        if (this.server != null) {
            try {
                this.server.start();
            }
            catch (Exception ex) {
                Logger.getLogger(HttpServer.class.getName()).log(Level.SEVERE, "start of HTTP server failed", ex);
            }
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void deploy(DeploymentInfo deployment) {
        this.server.deploy(deployment);
        this.deployed.add(deployment);
    }

    public void undeploy(DeploymentInfo deployment) {
        this.deployed.remove(deployment);
        this.server.undeploy(deployment);
    }

    public List<DeploymentInfo> listDeployed() {
        return this.deployed;
    }

    public static DeploymentInfo deployment() {
        return new DeploymentInfo();
    }

    public static ServletInfo servlet(String name, Class<? extends HttpServlet> servletClass) {
        return new ServletInfo(name, servletClass);
    }
}

