/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.setup;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import tigase.db.AuthRepository;
import tigase.db.AuthorizationException;
import tigase.db.TigaseDBException;
import tigase.http.AbstractModule;
import tigase.http.DeploymentInfo;
import tigase.http.HttpServer;
import tigase.http.ServiceImpl;
import tigase.http.ServletInfo;
import tigase.http.api.Service;
import tigase.http.setup.SetupServlet;
import tigase.util.TigaseStringprepException;
import tigase.xmpp.BareJID;

public class SetupModule
extends AbstractModule {
    private static final Logger log = Logger.getLogger(SetupModule.class.getCanonicalName());
    private static final String CREDENTIALS_KEY = "admin-credentials";
    private static final String NAME = "setup";
    private String contextPath = null;
    private HttpServer httpServer = null;
    private DeploymentInfo httpDeployment = null;
    private String[] vhosts = null;
    private Service service = null;
    private String adminUser = null;
    private String adminPassword = null;
    private final String uuid = UUID.randomUUID().toString();
    private static final ConcurrentHashMap<String, AbstractModule> modules = new ConcurrentHashMap();

    public static AbstractModule getModuleByUUID(String uuid) {
        return modules.get(uuid);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "Setup - handles basic configuration of Tigase XMPP Server";
    }

    @Override
    public void start() {
        if (this.httpDeployment != null) {
            this.stop();
        }
        super.start();
        this.service = new ServiceImpl(this){

            @Override
            public boolean isAdmin(BareJID user) {
                return user.toString().equals(SetupModule.this.adminUser) || super.isAdmin(user);
            }

            @Override
            public boolean checkCredentials(String user, String password) throws TigaseStringprepException, TigaseDBException, AuthorizationException {
                if (SetupModule.this.adminUser != null && SetupModule.this.adminPassword != null && SetupModule.this.adminUser.equals(user) && SetupModule.this.adminPassword.equals(password)) {
                    return true;
                }
                AuthRepository authRepository = SetupModule.this.getAuthRepository();
                if (authRepository == null) {
                    return false;
                }
                BareJID jid = BareJID.bareJIDInstance((String)user);
                return authRepository.plainAuth(jid, password);
            }
        };
        modules.put(this.uuid, this);
        this.httpDeployment = HttpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setService(this.service).setDeploymentName("Setup").setDeploymentDescription(this.getDescription());
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        ServletInfo servletInfo = HttpServer.servlet("SetupServlet", SetupServlet.class).addInitParam("module", this.uuid);
        servletInfo.addMapping("/*");
        this.httpDeployment.addServlets(servletInfo);
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            modules.remove(this.uuid, this);
            this.httpDeployment = null;
        }
        super.stop();
    }

    @Override
    public Map<String, Object> getDefaults() {
        Map<String, Object> props = super.getDefaults();
        props.put("context-path", "/" + this.getName());
        return props;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        if (props.containsKey("context-path")) {
            this.contextPath = (String)props.get("context-path");
        }
        if (props.containsKey("http-server")) {
            this.httpServer = (HttpServer)props.get("http-server");
        }
        if (props.containsKey(CREDENTIALS_KEY)) {
            String credentials = (String)props.get(CREDENTIALS_KEY);
            int idx = credentials.indexOf(":");
            if (idx > -1) {
                this.adminUser = credentials.substring(0, idx);
                this.adminPassword = credentials.substring(idx + 1);
            } else {
                this.adminUser = null;
                this.adminPassword = null;
            }
        }
        this.vhosts = (String[])props.get("vhosts");
    }

    protected Service getService() {
        return this.service;
    }
}

